/*
 * Decompiled with CFR 0.152.
 */
package nlScript;

import nlScript.core.Autocompletion;
import nlScript.core.DefaultParsedNode;
import nlScript.core.Matcher;
import nlScript.core.ParsingState;
import nlScript.core.Production;
import nlScript.core.Symbol;
import nlScript.ebnf.EBNFProduction;
import nlScript.ebnf.ParseListener;
import nlScript.ebnf.Rule;

public class ParsedNode
extends DefaultParsedNode {
    private int nthEntryInParent = 0;

    public ParsedNode(Matcher matcher, Symbol symbol, Production production) {
        super(matcher, symbol, production);
    }

    public void setNthEntryInParent(int nthEntry) {
        this.nthEntryInParent = nthEntry;
    }

    public int getNthEntryInParent() {
        return this.nthEntryInParent;
    }

    public Rule getRule() {
        Production production = this.getProduction();
        if (production != null && production instanceof EBNFProduction) {
            return ((EBNFProduction)production).getRule();
        }
        return null;
    }

    private boolean parentHasSameRule() {
        Rule thisRule = this.getRule();
        if (thisRule == null) {
            return false;
        }
        DefaultParsedNode parent = this.getParent();
        if (parent == null) {
            return false;
        }
        Rule parentRule = ((ParsedNode)parent).getRule();
        if (parentRule == null) {
            return false;
        }
        return thisRule.equals(parentRule);
    }

    @Override
    public Autocompletion[] getAutocompletion(boolean justCheck) {
        Rule rule = this.getRule();
        if (rule != null && rule.getAutocompleter() != null && !this.parentHasSameRule()) {
            return rule.getAutocompleter().getAutocompletion(this, justCheck);
        }
        return super.getAutocompletion(justCheck);
    }

    public void notifyListeners() {
        ParseListener l;
        for (int i = 0; i < this.numChildren(); ++i) {
            ((ParsedNode)this.getChild(i)).notifyListeners();
        }
        ParsingState state = this.getMatcher().state;
        if (state != ParsingState.SUCCESSFUL && state != ParsingState.END_OF_INPUT) {
            return;
        }
        Rule rule = this.getRule();
        if (rule != null && !this.parentHasSameRule() && (l = rule.getOnSuccessfulParsed()) != null) {
            l.parsed(this);
        }
    }

    @Override
    public Object evaluate() {
        Rule rule = this.getRule();
        if (rule != null && rule.getEvaluator() != null) {
            return rule.getEvaluator().evaluate(this);
        }
        return super.evaluate();
    }
}

