/*
 * Decompiled with CFR 0.152.
 */
package nlScript.core;

import java.util.ArrayList;
import java.util.Arrays;
import nlScript.Autocompleter;
import nlScript.core.Autocompletion;
import nlScript.core.Matcher;
import nlScript.core.Production;
import nlScript.core.Symbol;
import nlScript.core.Terminal;

public class DefaultParsedNode {
    private DefaultParsedNode parent = null;
    private final ArrayList<DefaultParsedNode> children = new ArrayList();
    private final Symbol symbol;
    private final Production production;
    private final Matcher matcher;
    private String name;

    public DefaultParsedNode(Matcher matcher, Symbol symbol, Production production) {
        this.matcher = matcher;
        this.symbol = symbol;
        this.production = production;
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public String getName() {
        return this.name != null ? this.name : this.symbol.getSymbol();
    }

    public void setName(String name) {
        this.name = name;
    }

    public Production getProduction() {
        return this.production;
    }

    public Matcher getMatcher() {
        return this.matcher;
    }

    public boolean doesAutocomplete() {
        return this.getAutocompletion(true) != null;
    }

    public Autocompletion[] getAutocompletion(boolean justCheck) {
        return Autocompleter.FALLBACK_AUTOCOMPLETER.getAutocompletion(this, justCheck);
    }

    public int numChildren() {
        return this.children.size();
    }

    public final DefaultParsedNode[] getChildren() {
        return this.children.toArray(new DefaultParsedNode[0]);
    }

    public DefaultParsedNode getChild(int i) {
        return this.children.get(i);
    }

    public DefaultParsedNode getChild(String name) {
        for (DefaultParsedNode n : this.children) {
            if (!name.equals(n.getName())) continue;
            return n;
        }
        return null;
    }

    public void addChildren(DefaultParsedNode ... children) {
        this.children.addAll(Arrays.asList(children));
        for (DefaultParsedNode child : children) {
            child.parent = this;
        }
    }

    public DefaultParsedNode getParent() {
        return this.parent;
    }

    public void removeAllChildren() {
        for (DefaultParsedNode child : this.children) {
            child.parent = null;
        }
        this.children.clear();
    }

    public Object evaluate() {
        if (this.symbol.isTerminal()) {
            return ((Terminal)this.symbol).evaluate(this.getMatcher());
        }
        return this.getParsedString();
    }

    public Object evaluate(int child) {
        return this.children.get(child).evaluate();
    }

    public Object evaluate(String ... names) {
        DefaultParsedNode pn = this;
        for (String name : names) {
            if ((pn = pn.getChild(name)) != null) continue;
            return null;
        }
        return pn.evaluate();
    }

    public String getParsedString() {
        return this.matcher.parsed;
    }

    public String getParsedString(String ... names) {
        DefaultParsedNode pn = this;
        for (String name : names) {
            if ((pn = pn.getChild(name)) != null) continue;
            return "";
        }
        return pn.getParsedString();
    }

    public String toString() {
        return this.getParsedString();
    }
}

