/*
 * Decompiled with CFR 0.152.
 */
package nlScript.core;

import java.util.ArrayList;
import java.util.HashSet;
import nlScript.core.BNF;
import nlScript.core.Named;
import nlScript.core.Production;
import nlScript.core.Symbol;
import nlScript.util.RandomString;

public class NonTerminal
extends Symbol {
    private static final RandomString rs = new RandomString(8);

    public NonTerminal(String symbol) {
        super(symbol != null ? symbol : NonTerminal.makeRandomSymbol());
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public boolean isNonTerminal() {
        return true;
    }

    @Override
    public boolean isEpsilon() {
        return false;
    }

    public Named<NonTerminal> withName(String name) {
        return new Named<NonTerminal>(this, name);
    }

    public Named<NonTerminal> withName() {
        return new Named<NonTerminal>(this);
    }

    public boolean uses(Symbol symbol, BNF bnf) {
        return this.uses(symbol, bnf, new HashSet<Production>());
    }

    private boolean uses(Symbol symbol, BNF bnf, HashSet<Production> progressing) {
        ArrayList<Production> productions = bnf.getProductions(this);
        for (Production p : productions) {
            Symbol[] rhs;
            if (progressing.contains(p)) continue;
            progressing.add(p);
            for (Symbol rSym : rhs = p.getRight()) {
                if (rSym.equals(symbol)) {
                    return true;
                }
                if (!(rSym instanceof NonTerminal) || !((NonTerminal)rSym).uses(symbol, bnf, progressing)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return "<" + this.getSymbol() + ">";
    }

    public static String makeRandomSymbol() {
        return rs.nextString();
    }
}

