/*
 * Decompiled with CFR 0.152.
 */
package nlScript.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import nlScript.ParseException;
import nlScript.core.Autocompletion;
import nlScript.core.BNF;
import nlScript.core.DefaultParsedNode;
import nlScript.core.Lexer;
import nlScript.core.Matcher;
import nlScript.core.NonTerminal;
import nlScript.core.ParsedNodeFactory;
import nlScript.core.ParsingState;
import nlScript.core.Production;
import nlScript.core.Symbol;
import nlScript.core.Terminal;

public class RDParser {
    private final ParsedNodeFactory parsedNodeFactory;
    private final BNF grammar;
    private final Lexer lexer;

    public RDParser(BNF grammar, Lexer lexer, ParsedNodeFactory parsedNodeFactory) {
        this.grammar = grammar;
        this.lexer = lexer;
        this.parsedNodeFactory = parsedNodeFactory;
    }

    public Lexer getLexer() {
        return this.lexer;
    }

    public BNF getGrammar() {
        return this.grammar;
    }

    public ParsedNodeFactory getParsedNodeFactory() {
        return this.parsedNodeFactory;
    }

    public DefaultParsedNode parse() throws ParseException {
        return this.parse(null);
    }

    public DefaultParsedNode parse(ArrayList<Autocompletion> autocompletions) throws ParseException {
        SymbolSequence seq = new SymbolSequence(BNF.ARTIFICIAL_START_SYMBOL);
        ArrayList<SymbolSequence> endOfInput = new ArrayList<SymbolSequence>();
        SymbolSequence parsedSequence = this.parseRecursive(seq, endOfInput);
        if (autocompletions != null) {
            this.collectAutocompletions(endOfInput, autocompletions);
        }
        DefaultParsedNode[] last = new DefaultParsedNode[1];
        DefaultParsedNode ret = this.createParsedTree(parsedSequence, last);
        ret = this.buildAst(ret);
        if (ret.getMatcher().state == ParsingState.FAILED) {
            throw new ParseException(ret, last[0], this);
        }
        return ret;
    }

    private DefaultParsedNode buildAst(DefaultParsedNode pn) {
        DefaultParsedNode[] children = new DefaultParsedNode[pn.numChildren()];
        for (int i = 0; i < pn.numChildren(); ++i) {
            children[i] = this.buildAst(pn.getChild(i));
        }
        pn.removeAllChildren();
        if (pn.getProduction() != null) {
            pn.getProduction().builtAST(pn, children);
        }
        return pn;
    }

    private void collectAutocompletions(ArrayList<SymbolSequence> endOfInput, ArrayList<Autocompletion> autocompletions) {
        assert (autocompletions != null);
        ArrayList<DefaultParsedNode> autocompletingParents = new ArrayList<DefaultParsedNode>();
        for (SymbolSequence seq : endOfInput) {
            this.collectAutocompletingParents(seq, autocompletingParents);
        }
        HashSet<String> done = new HashSet<String>();
        for (DefaultParsedNode autocompletingParent : autocompletingParents) {
            Production prod = autocompletingParent.getProduction();
            String key = null;
            if (prod != null) {
                key = prod.getLeft().getSymbol() + ":";
                for (Symbol s : prod.getRight()) {
                    key = key + s.getSymbol();
                }
            } else {
                key = autocompletingParent.getSymbol().getSymbol();
            }
            if (done.contains(key)) continue;
            boolean veto = this.addAutocompletions(autocompletingParent, autocompletions);
            done.add(key);
            if (!veto) continue;
            break;
        }
    }

    private void collectAutocompletingParents(SymbolSequence symbolSequence, ArrayList<DefaultParsedNode> autocompletingParents) {
        DefaultParsedNode[] last = new DefaultParsedNode[1];
        DefaultParsedNode treeRoot = this.createParsedTree(symbolSequence, last);
        ArrayList<DefaultParsedNode> pathToRoot = new ArrayList<DefaultParsedNode>();
        for (DefaultParsedNode parent = last[0]; parent != null; parent = parent.getParent()) {
            pathToRoot.add(parent);
        }
        DefaultParsedNode autocompletingParent = null;
        for (int i = pathToRoot.size() - 1; i >= 0; --i) {
            DefaultParsedNode tmp = (DefaultParsedNode)pathToRoot.get(i);
            if (!tmp.doesAutocomplete()) continue;
            autocompletingParent = tmp;
            break;
        }
        if (autocompletingParent != null) {
            autocompletingParents.add(autocompletingParent);
        }
    }

    private boolean addAutocompletions(DefaultParsedNode autocompletingParent, ArrayList<Autocompletion> autocompletions) {
        int autocompletingParentStart = autocompletingParent.getMatcher().pos;
        String alreadyEntered = this.lexer.substring(autocompletingParentStart);
        Autocompletion[] completion = autocompletingParent.getAutocompletion(false);
        if (completion != null) {
            for (Autocompletion c : completion) {
                if (c == null || c.isEmptyLiteral()) continue;
                if (c instanceof Autocompletion.Veto) {
                    autocompletions.clear();
                    return true;
                }
                c.setAlreadyEntered(alreadyEntered);
                if (!autocompletions.stream().noneMatch(ac -> ac.getCompletion(Autocompletion.Purpose.FOR_MENU).equals(c.getCompletion(Autocompletion.Purpose.FOR_MENU)))) continue;
                autocompletions.add(c);
            }
        }
        return false;
    }

    private SymbolSequence parseRecursive(SymbolSequence symbolSequence, ArrayList<SymbolSequence> endOfInput) {
        Symbol next = symbolSequence.getCurrentSymbol();
        while (next.isTerminal()) {
            Matcher matcher = ((Terminal)next).matches(this.lexer);
            symbolSequence.addMatcher(matcher);
            if (matcher.state == ParsingState.END_OF_INPUT && endOfInput != null) {
                endOfInput.add(symbolSequence);
            }
            if (matcher.state != ParsingState.SUCCESSFUL) {
                return symbolSequence;
            }
            symbolSequence.incrementPosition();
            this.lexer.fwd(matcher.parsed.length());
            if (this.lexer.isDone()) {
                return symbolSequence;
            }
            next = symbolSequence.getCurrentSymbol();
        }
        NonTerminal u = (NonTerminal)next;
        ArrayList<Production> alternates = this.grammar.getProductions(u);
        SymbolSequence best = null;
        int lexerPosOfBest = this.lexer.getPosition();
        for (Production alternate : alternates) {
            int lexerPos = this.lexer.getPosition();
            SymbolSequence nextSequence = symbolSequence.replaceCurrentSymbol(alternate);
            SymbolSequence parsedSequence = this.parseRecursive(nextSequence, endOfInput);
            Matcher m = parsedSequence.getLastMatcher();
            if (m != null) {
                if (m.state == ParsingState.SUCCESSFUL) {
                    return parsedSequence;
                }
                if (best == null || m.isBetterThan(best.getLastMatcher())) {
                    best = parsedSequence;
                    lexerPosOfBest = this.lexer.getPosition();
                }
            }
            this.lexer.setPosition(lexerPos);
        }
        if (best != null) {
            this.lexer.setPosition(lexerPosOfBest);
        }
        return best;
    }

    protected DefaultParsedNode createParsedTree(SymbolSequence leafSequence, DefaultParsedNode[] retLast) {
        LinkedList<DefaultParsedNode> parsedNodeSequence = new LinkedList<DefaultParsedNode>();
        int nParsedMatchers = leafSequence.parsedMatchers.size();
        int i = 0;
        for (Symbol symbol : leafSequence.sequence) {
            Matcher matcher = i < nParsedMatchers ? (Matcher)leafSequence.parsedMatchers.get(i) : new Matcher(ParsingState.NOT_PARSED, 0, "");
            ++i;
            DefaultParsedNode pn = this.parsedNodeFactory.createNode(matcher, symbol, null);
            parsedNodeSequence.add(pn);
        }
        if (retLast != null) {
            retLast[0] = (DefaultParsedNode)parsedNodeSequence.get(nParsedMatchers - 1);
        }
        SymbolSequence childSequence = leafSequence;
        while (childSequence.parent != null) {
            SymbolSequence parentSequence = childSequence.parent;
            Production productionToCreateChildSequence = childSequence.production;
            assert (productionToCreateChildSequence != null);
            int pos = parentSequence.pos;
            Symbol[] rhs = productionToCreateChildSequence.getRight();
            NonTerminal lhs = productionToCreateChildSequence.getLeft();
            int rhsSize = rhs.length;
            List<DefaultParsedNode> childList = parsedNodeSequence.subList(pos, pos + rhsSize);
            Matcher matcher = RDParser.matcherFromChildSequence(childList);
            DefaultParsedNode newParent = this.parsedNodeFactory.createNode(matcher, lhs, productionToCreateChildSequence);
            newParent.addChildren(childList.toArray(new DefaultParsedNode[0]));
            childList.clear();
            parsedNodeSequence.add(pos, newParent);
            childSequence = childSequence.parent;
        }
        DefaultParsedNode root = (DefaultParsedNode)parsedNodeSequence.get(0);
        assert (root.getSymbol().equals(BNF.ARTIFICIAL_START_SYMBOL));
        RDParser.notifyExtensionListeners(root);
        return root;
    }

    private static void notifyExtensionListeners(DefaultParsedNode pn) {
        Production production = pn.getProduction();
        if (production != null) {
            production.wasExtended(pn, pn.getChildren());
            for (DefaultParsedNode child : pn.getChildren()) {
                RDParser.notifyExtensionListeners(child);
            }
        }
    }

    private static Matcher matcherFromChildSequence(List<DefaultParsedNode> children) {
        int pos = -1;
        ParsingState state = ParsingState.NOT_PARSED;
        StringBuilder parsed = new StringBuilder();
        for (DefaultParsedNode child : children) {
            if (state == ParsingState.END_OF_INPUT || state == ParsingState.FAILED) break;
            Matcher matcher = child.getMatcher();
            ParsingState childState = matcher.state;
            if (childState != ParsingState.NOT_PARSED) {
                if (pos == -1) {
                    pos = matcher.pos;
                }
                if (state == ParsingState.NOT_PARSED || !childState.isBetterThan(state)) {
                    state = childState;
                }
            }
            parsed.append(matcher.parsed);
        }
        if (pos == -1) {
            pos = 0;
        }
        return new Matcher(state, pos, parsed.toString());
    }

    protected static class SymbolSequence {
        private final LinkedList<Symbol> sequence = new LinkedList();
        private int pos = 0;
        private final SymbolSequence parent;
        private final ArrayList<Matcher> parsedMatchers = new ArrayList();
        private final Production production;

        private SymbolSequence(SymbolSequence o, Production production) {
            this.sequence.addAll(o.sequence);
            this.pos = o.pos;
            this.parent = o;
            this.production = production;
        }

        public SymbolSequence(Symbol start) {
            this.sequence.add(start);
            this.parent = null;
            this.production = null;
        }

        public Matcher getLastMatcher() {
            return this.parsedMatchers.get(this.parsedMatchers.size() - 1);
        }

        public void addMatcher(Matcher matcher) {
            this.parsedMatchers.add(matcher);
        }

        public Symbol getCurrentSymbol() {
            return this.sequence.get(this.pos);
        }

        public SymbolSequence replaceCurrentSymbol(Production production) {
            SymbolSequence copy = new SymbolSequence(this, production);
            copy.parsedMatchers.addAll(this.parsedMatchers);
            copy.sequence.remove(this.pos);
            Symbol[] replacement = production.getRight();
            for (int i = 0; i < replacement.length; ++i) {
                copy.sequence.add(this.pos + i, replacement[i]);
            }
            return copy;
        }

        public void incrementPosition() {
            ++this.pos;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            for (Symbol sym : this.sequence) {
                if (i++ == this.pos) {
                    sb.append(".");
                }
                sb.append(sym).append(" -- ");
            }
            return sb.toString();
        }
    }
}

