/*
 * Decompiled with CFR 0.152.
 */
package nlScript;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import nlScript.core.Autocompletion;
import nlScript.core.BNF;
import nlScript.core.DefaultParsedNode;
import nlScript.core.Lexer;
import nlScript.core.RDParser;

public class ParseException
extends Exception {
    private final DefaultParsedNode root;
    private final DefaultParsedNode failedTerminal;
    private final RDParser parser;
    private final DefaultParsedNode firstAutocompletingAncestorThatFailed;

    public ParseException(DefaultParsedNode root, DefaultParsedNode failedTerminal, RDParser parser) {
        DefaultParsedNode tmp;
        this.root = root;
        this.failedTerminal = failedTerminal;
        this.parser = parser;
        for (tmp = failedTerminal; tmp != null && !tmp.doesAutocomplete(); tmp = tmp.getParent()) {
        }
        this.firstAutocompletingAncestorThatFailed = tmp;
    }

    @Override
    public String getMessage() {
        return this.getError();
    }

    public DefaultParsedNode getRoot() {
        return this.root;
    }

    public DefaultParsedNode getFailedTerminal() {
        return this.failedTerminal;
    }

    public DefaultParsedNode getFirstAutocompletingAncestorThatFailed() {
        return this.firstAutocompletingAncestorThatFailed;
    }

    public String getError() {
        Lexer lexer = this.parser.getLexer();
        BNF grammar = this.parser.getGrammar();
        int errorPos = this.failedTerminal.getMatcher().pos + this.failedTerminal.getMatcher().parsed.length() - 1;
        String workingText = lexer.substring(0, this.failedTerminal.getMatcher().pos);
        Lexer workingLexer = new Lexer(workingText);
        RDParser parser2 = new RDParser(grammar, workingLexer, this.parser.getParsedNodeFactory());
        ArrayList<Autocompletion> expectations = new ArrayList<Autocompletion>();
        try {
            parser2.parse(expectations);
        }
        catch (ParseException e) {
            return "Error at position " + errorPos;
        }
        String[] lines = lexer.substring(0, errorPos + 1).split("\\r?\\n|\\r");
        int errorLine = lines.length - 1;
        int errorPosInLastLine = lines[errorLine].length() - 1;
        StringBuilder errorMessage = new StringBuilder();
        String nl = System.lineSeparator();
        errorMessage.append("Error at position ").append(errorPos).append(" in line ").append(errorLine).append(":").append(nl);
        errorMessage.append(lines[errorLine]).append(nl);
        for (int i = 0; i < errorPosInLastLine; ++i) {
            errorMessage.append(" ");
        }
        errorMessage.append("^").append(nl);
        List exString = expectations.stream().map(ac -> ac.getCompletion(Autocompletion.Purpose.FOR_INSERTION)).collect(Collectors.toList());
        errorMessage.append("Expected ").append(exString);
        return errorMessage.toString();
    }
}

