/*
 * Decompiled with CFR 0.152.
 */
package nlScript.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;

abstract class HighlightPainter
extends DefaultHighlighter.DefaultHighlightPainter {
    private Color color;
    private boolean active = true;

    HighlightPainter(Color color) {
        super(color);
        this.setColor(color);
    }

    public void setActive(boolean b) {
        this.active = b;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public Shape paintLayer(Graphics g, int p0, int p1, Shape viewBounds, JTextComponent c, View view) {
        if (!this.active) {
            return null;
        }
        g.setColor(this.getColor());
        if (++p0 == p1) {
            try {
                Shape s = view.modelToView(p0, viewBounds, Position.Bias.Forward);
                Rectangle r = s.getBounds();
                g.drawLine(r.x, r.y, r.x, r.y + r.height);
                return r;
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
                return null;
            }
        }
        if (p0 == view.getStartOffset() && p1 == view.getEndOffset()) {
            Rectangle alloc = viewBounds instanceof Rectangle ? (Rectangle)viewBounds : viewBounds.getBounds();
            this.draw(g, alloc.x, alloc.y, alloc.width - 1, alloc.height - 1);
            return alloc;
        }
        try {
            Shape shape = view.modelToView(p0, Position.Bias.Forward, p1, Position.Bias.Backward, viewBounds);
            Rectangle r = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            this.draw(g, r.x, r.y, r.width - 1, r.height - 1);
            return r;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected abstract void draw(Graphics var1, int var2, int var3, int var4, int var5);

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color cannot be null");
        }
        this.color = color;
    }

    static class Squiggle
    extends HighlightPainter {
        Squiggle(Color color) {
            super(color);
        }

        @Override
        protected void draw(Graphics g, int x, int y, int w, int h) {
            g.fillRect(x, y, w, h);
        }
    }

    static class Outline
    extends HighlightPainter {
        Outline(Color color) {
            super(color);
        }

        @Override
        protected void draw(Graphics g, int x, int y, int w, int h) {
            g.drawRect(x, y, w, h);
        }
    }
}

