/*
 * Decompiled with CFR 0.152.
 */
package nlScript.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import nlScript.core.NonTerminal;
import nlScript.core.Production;
import nlScript.core.Symbol;
import nlScript.core.Terminal;

public class BNF {
    static final Logger logger = Logger.getLogger(BNF.class.getName());
    public static final NonTerminal ARTIFICIAL_START_SYMBOL;
    public static final Terminal ARTIFICIAL_STOP_SYMBOL;
    private final HashMap<String, Symbol> symbols = new HashMap();
    private final ArrayList<Production> productions = new ArrayList();

    public BNF() {
    }

    public BNF(BNF other) {
        this();
        this.symbols.putAll(other.symbols);
        this.productions.addAll(other.productions);
    }

    public void reset() {
        this.symbols.clear();
        this.productions.clear();
    }

    public void removeStartProduction() {
        for (int i = this.productions.size() - 1; i >= 0; --i) {
            if (!this.productions.get(i).getLeft().equals(ARTIFICIAL_START_SYMBOL)) continue;
            this.productions.remove(i);
            break;
        }
    }

    public void removeProductions(Set<Production> productions) {
        this.productions.removeIf(productions::contains);
    }

    public Production addProduction(Production p) {
        int existing = this.productions.indexOf(p);
        if (existing >= 0) {
            logger.info("Production already exists: " + this.productions.get(existing));
            return this.productions.get(existing);
        }
        this.productions.add(p);
        this.symbols.put(p.getLeft().getSymbol(), p.getLeft());
        for (Symbol s : p.getRight()) {
            if (s.isEpsilon()) continue;
            this.symbols.put(s.getSymbol(), s);
        }
        return p;
    }

    public Symbol getSymbol(String symbol) {
        Symbol ret = this.symbols.get(symbol);
        if (ret == null) {
            throw new RuntimeException("Could not find symbol " + symbol);
        }
        return ret;
    }

    public ArrayList<Production> getProductions(NonTerminal left) {
        ArrayList<Production> ret = new ArrayList<Production>(this.productions);
        ret.removeIf(p -> !p.getLeft().equals(left));
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Production p : this.productions) {
            sb.append(p.toString()).append(System.lineSeparator());
        }
        return sb.toString();
    }

    static {
        logger.setLevel(Level.INFO);
        ARTIFICIAL_START_SYMBOL = new NonTerminal("S'");
        ARTIFICIAL_STOP_SYMBOL = Terminal.END_OF_INPUT;
    }
}

