/*
 * Decompiled with CFR 0.152.
 */
package nlScript.core;

public class Lexer {
    private final String input;
    private int pos = 0;

    public Lexer(String input) {
        this.input = input;
    }

    public int getPosition() {
        return this.pos;
    }

    public void setPosition(int pos) {
        this.pos = pos;
    }

    public void fwd(int len) {
        this.pos += len;
    }

    public char peek() {
        return this.peek(0);
    }

    public char peek(int n) {
        int p = this.pos + n;
        return p < this.input.length() ? this.input.charAt(p) : (char)'$';
    }

    public String substring(int from, int to) {
        if (to > this.input.length()) {
            to = this.input.length();
        }
        return this.input.substring(from, to);
    }

    public String substring(int from) {
        return this.input.substring(from);
    }

    public boolean isDone() {
        return this.pos > this.input.length();
    }

    public boolean isAtEnd() {
        return this.isAtEnd(0);
    }

    public boolean isAtEnd(int fwd) {
        return this.pos + fwd == this.input.length();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.input.substring(0, this.pos)).append(" -- ").append(this.input.substring(this.pos));
        return sb.toString();
    }
}

