/*
 * Decompiled with CFR 0.152.
 */
package nlScript.ebnf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import nlScript.Evaluator;
import nlScript.core.Autocompletion;
import nlScript.core.BNF;
import nlScript.core.Named;
import nlScript.core.NonTerminal;
import nlScript.core.Production;
import nlScript.core.Symbol;
import nlScript.core.Terminal;
import nlScript.ebnf.Join;
import nlScript.ebnf.NamedRule;
import nlScript.ebnf.Optional;
import nlScript.ebnf.Or;
import nlScript.ebnf.Plus;
import nlScript.ebnf.Repeat;
import nlScript.ebnf.Rule;
import nlScript.ebnf.Sequence;
import nlScript.ebnf.Star;
import nlScript.util.Range;

public class EBNFCore {
    protected final HashMap<String, Symbol> symbols = new HashMap();
    private final ArrayList<Rule> rules = new ArrayList();
    private final BNF bnf = new BNF();

    public EBNFCore() {
    }

    public EBNFCore(EBNFCore other) {
        this.symbols.putAll(other.symbols);
        this.rules.addAll(other.rules);
    }

    public Symbol getSymbol(String type) {
        return this.symbols.get(type);
    }

    public void compile(Symbol topLevelSymbol) {
        this.removeRules(BNF.ARTIFICIAL_START_SYMBOL);
        Sequence sequence = new Sequence(BNF.ARTIFICIAL_START_SYMBOL, topLevelSymbol, BNF.ARTIFICIAL_STOP_SYMBOL);
        this.addRule(sequence);
        sequence.setEvaluator(Evaluator.FIRST_CHILD_EVALUATOR);
    }

    public BNF getBNF() {
        return this.bnf;
    }

    public ArrayList<Rule> getRules(NonTerminal target) {
        ArrayList<Rule> ret = new ArrayList<Rule>(this.rules);
        ret.removeIf(p -> !p.getTarget().equals(target));
        return ret;
    }

    public Rule plus(String type, Named<?> child) {
        NonTerminal tgt = this.newOrExistingNonTerminal(type);
        Plus plus = new Plus(tgt, child.getSymbol());
        plus.setParsedChildNames(child.getName());
        this.addRule(plus);
        return plus;
    }

    public Rule star(String type, Named<?> child) {
        NonTerminal tgt = this.newOrExistingNonTerminal(type);
        Star star = new Star(tgt, child.getSymbol());
        star.setParsedChildNames(child.getName());
        this.addRule(star);
        return star;
    }

    public Rule or(String type, Named<?> ... options) {
        NonTerminal tgt = this.newOrExistingNonTerminal(type);
        Or or = new Or(tgt, EBNFCore.getSymbols(options));
        or.setParsedChildNames(EBNFCore.getNames(options));
        this.addRule(or);
        return or;
    }

    public Rule optional(String type, Named<?> child) {
        NonTerminal tgt = this.newOrExistingNonTerminal(type);
        Optional optional = new Optional(tgt, child.getSymbol());
        optional.setParsedChildNames(child.getName());
        this.addRule(optional);
        return optional;
    }

    public Rule repeat(String type, Named<?> child, int from, int to) {
        NonTerminal tgt = this.newOrExistingNonTerminal(type);
        Repeat repeat = new Repeat(tgt, child.getSymbol(), from, to);
        repeat.setParsedChildNames(child.getName());
        this.addRule(repeat);
        return repeat;
    }

    public Rule repeat(String type, Named<?> child, String ... names) {
        NonTerminal tgt = this.newOrExistingNonTerminal(type);
        int n = names.length;
        Repeat repeat = new Repeat(tgt, child.getSymbol(), n, n);
        repeat.setParsedChildNames(names);
        this.addRule(repeat);
        return repeat;
    }

    public Rule join(String type, Named<?> child, Symbol open, Symbol close, Symbol delimiter, Range cardinality) {
        return this.join(type, child, open, close, delimiter, true, cardinality);
    }

    public Rule join(String type, Named<?> child, Symbol open, Symbol close, Symbol delimiter, boolean onlyKeepEntries, Range cardinality) {
        NonTerminal tgt = this.newOrExistingNonTerminal(type);
        Join join = new Join(tgt, child.getSymbol(), open, close, delimiter, cardinality);
        join.setOnlyKeepEntries(onlyKeepEntries);
        join.setParsedChildNames(child.getName());
        this.addRule(join);
        return join;
    }

    public Rule join(String type, Named<?> child, Symbol open, Symbol close, Symbol delimiter, String ... names) {
        return this.join(type, child, open, close, delimiter, true, names);
    }

    public Rule join(String type, Named<?> child, Symbol open, Symbol close, Symbol delimiter, boolean onlyKeepEntries, String ... names) {
        NonTerminal tgt = this.newOrExistingNonTerminal(type);
        int n = names.length;
        Join join = new Join(tgt, child.getSymbol(), open, close, delimiter, new Range(n, n));
        join.setOnlyKeepEntries(onlyKeepEntries);
        join.setParsedChildNames(names);
        this.addRule(join);
        return join;
    }

    public Rule list(String type, Named<?> child) {
        NamedRule wsStar = this.star(null, Terminal.WHITESPACE.withName()).withName("ws*");
        Rule delimiter = this.sequence(null, wsStar, Terminal.literal(",").withName(), wsStar);
        delimiter.setAutocompleter((pn, justCheck) -> Autocompletion.literal(pn, pn.getParsedString().isEmpty() ? ", " : ""));
        return this.join(type, child, null, null, (Symbol)delimiter.tgt, Range.STAR);
    }

    public Rule tuple(String type, Named<?> child, String ... names) {
        NamedRule wsStar = this.star(null, Terminal.WHITESPACE.withName()).withName("ws*");
        ((Rule)wsStar.get()).setAutocompleter((pn, justCheck) -> Autocompletion.literal(pn, ""));
        Rule open = this.sequence(null, Terminal.literal("(").withName("open"), wsStar);
        Rule close = this.sequence(null, wsStar, Terminal.literal(")").withName("close"));
        Rule delimiter = this.sequence(null, wsStar, Terminal.literal(",").withName("delimiter"), wsStar);
        Rule ret = this.join(type, child, (Symbol)open.tgt, (Symbol)close.tgt, (Symbol)delimiter.tgt, names);
        ret.setAutocompleter((pn, justCheck) -> {
            if (!pn.getParsedString().isEmpty()) {
                return null;
            }
            if (justCheck) {
                return Autocompletion.doesAutocomplete(pn);
            }
            Autocompletion.EntireSequence seq = new Autocompletion.EntireSequence(pn);
            seq.addLiteral(open.tgt, "open", "(");
            seq.addParameterized(child.getSymbol(), names[0], names[0]);
            for (int i = 1; i < names.length; ++i) {
                seq.addLiteral(delimiter.tgt, "delimiter", ", ");
                seq.addParameterized(child.getSymbol(), names[i], names[i]);
            }
            seq.addLiteral(close.tgt, "close", ")");
            return seq.asArray();
        });
        return ret;
    }

    public Rule sequence(String type, Named<?> ... children) {
        NonTerminal tgt = this.newOrExistingNonTerminal(type);
        Sequence sequence = new Sequence(tgt, EBNFCore.getSymbols(children));
        sequence.setParsedChildNames(EBNFCore.getNames(children));
        this.addRule(sequence);
        return sequence;
    }

    protected static Symbol[] getSymbols(Named<?> ... named) {
        Symbol[] ret = new Symbol[named.length];
        for (int i = 0; i < named.length; ++i) {
            ret[i] = named[i].getSymbol();
        }
        return ret;
    }

    protected static String[] getNames(Named<?> ... named) {
        String[] ret = new String[named.length];
        for (int i = 0; i < named.length; ++i) {
            ret[i] = named[i].getName();
        }
        return ret;
    }

    private void addRule(Rule rule) {
        if (!this.symbols.containsKey(rule.tgt.getSymbol())) {
            this.symbols.put(rule.tgt.getSymbol(), rule.tgt);
        }
        for (Symbol s : rule.children) {
            if (s.isEpsilon() || this.symbols.containsKey(s.getSymbol())) continue;
            this.symbols.put(s.getSymbol(), s);
        }
        this.rules.add(rule);
        rule.createBNF(this.bnf);
    }

    public void removeRules(NonTerminal symbol) {
        HashSet<Production> toRemove = new HashSet<Production>();
        for (int i = this.rules.size() - 1; i >= 0; --i) {
            if (!this.rules.get((int)i).tgt.equals(symbol)) continue;
            Rule rule = this.rules.remove(i);
            for (Production production : rule.productions) {
                toRemove.add(production);
            }
        }
        this.bnf.removeProductions(toRemove);
    }

    private NonTerminal newOrExistingNonTerminal(String type) {
        if (type == null) {
            return null;
        }
        Symbol s = this.symbols.get(type);
        if (s == null) {
            s = new NonTerminal(type);
        }
        return (NonTerminal)s;
    }
}

