/*
 * Decompiled with CFR 0.152.
 */
package nlScript.ebnf;

import nlScript.Evaluator;
import nlScript.ParsedNode;
import nlScript.core.BNF;
import nlScript.core.DefaultParsedNode;
import nlScript.core.NonTerminal;
import nlScript.core.Production;
import nlScript.core.Symbol;
import nlScript.core.Terminal;
import nlScript.ebnf.EBNFProduction;
import nlScript.ebnf.Repeat;
import nlScript.ebnf.Rule;
import nlScript.ebnf.Star;
import nlScript.util.Range;

public class Join
extends Rule {
    private final Symbol open;
    private final Symbol close;
    private final Symbol delimiter;
    private Range cardinality;
    private boolean onlyKeepEntries = true;

    public Join(NonTerminal tgt, Symbol entry, Symbol open, Symbol close, Symbol delimiter, Range cardinality) {
        super("join", tgt, entry);
        this.open = open;
        this.close = close;
        this.delimiter = delimiter;
        this.cardinality = cardinality;
        this.setEvaluator(Evaluator.ALL_CHILDREN_EVALUATOR);
    }

    public Symbol getEntry() {
        return this.children[0];
    }

    public Range getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(Range cardinality) {
        this.cardinality = cardinality;
    }

    public void setOnlyKeepEntries(boolean onlyKeepEntries) {
        this.onlyKeepEntries = onlyKeepEntries;
    }

    @Override
    public void createBNF(BNF g) {
        EBNFProduction p;
        boolean hasDelimiter;
        Symbol first = this.children[0];
        NonTerminal next = new NonTerminal("next-" + NonTerminal.makeRandomSymbol());
        boolean hasOpen = this.open != null && !this.open.isEpsilon();
        boolean hasClose = this.close != null && !this.close.isEpsilon();
        boolean bl = hasDelimiter = this.delimiter != null && !this.delimiter.isEpsilon();
        if (hasDelimiter) {
            p = Join.addProduction(g, this, next, this.delimiter, first);
            p.onExtension((parent, children) -> {
                int nthEntry = ((ParsedNode)parent).getNthEntryInParent() + 1;
                children[0].setName("delimiter");
                children[1].setName(this.getNameForChild(nthEntry));
            });
            if (this.onlyKeepEntries) {
                p.setAstBuilder((parent, children) -> parent.addChildren(children[1]));
            } else {
                p.setAstBuilder(Production.AstBuilder.DEFAULT);
            }
        } else {
            p = Join.addProduction(g, this, next, first);
            p.onExtension((parent, children) -> {
                int nthEntry = ((ParsedNode)parent).getNthEntryInParent() + 1;
                children[0].setName(this.getNameForChild(nthEntry));
            });
            p.setAstBuilder((parent, children) -> parent.addChildren(children[0]));
        }
        Production.AstBuilder astBuilder = (parent, children) -> {
            parent.addChildren(children[0]);
            for (DefaultParsedNode pn : children[1].getChildren()) {
                parent.addChildren(pn.getChildren());
            }
        };
        NonTerminal repetition = new NonTerminal("repetition:" + NonTerminal.makeRandomSymbol());
        if (this.cardinality.equals(Range.PLUS)) {
            Star star = new Star(null, next);
            star.setParsedChildNames("next");
            star.createBNF(g);
            this.productions.addAll(star.productions);
            EBNFProduction p2 = Join.addProduction(g, this, repetition, first, star.tgt);
            p2.onExtension((parent, children) -> {
                children[0].setName(this.getNameForChild(0));
                children[1].setName("star");
            });
            p2.setAstBuilder(astBuilder);
        } else if (this.cardinality.equals(Range.STAR)) {
            Star star = new Star(null, next);
            star.setParsedChildNames("next");
            star.createBNF(g);
            this.productions.addAll(star.productions);
            EBNFProduction p1 = Join.addProduction(g, this, repetition, first, star.tgt);
            EBNFProduction p2 = Join.addProduction(g, this, repetition, Terminal.EPSILON);
            p1.setAstBuilder(astBuilder);
            p2.setAstBuilder((parent, children) -> {});
            p1.onExtension((parent, children) -> {
                children[0].setName(this.getNameForChild(0));
                children[1].setName("star");
            });
        } else if (this.cardinality.equals(Range.OPTIONAL)) {
            EBNFProduction p1 = Join.addProduction(g, this, repetition, first);
            p1.onExtension((parent, children) -> children[0].setName(this.getNameForChild(0)));
            EBNFProduction p2 = Join.addProduction(g, this, repetition, Terminal.EPSILON);
            p2.setAstBuilder((parent, children) -> {});
        } else {
            int lower = this.cardinality.getLower();
            int upper = this.cardinality.getUpper();
            if (lower == 0 && upper == 0) {
                Join.addProduction(g, this, repetition, Terminal.EPSILON).setAstBuilder((parent, children) -> {});
            } else if (lower == 1 && upper == 1) {
                EBNFProduction p3 = Join.addProduction(g, this, repetition, first);
                p3.onExtension((parent, children) -> children[0].setName(this.getNameForChild(0)));
            } else if (lower <= 0) {
                Repeat repeat = new Repeat(null, (Symbol)next, 0, upper - 1);
                repeat.setParsedChildNames("next");
                repeat.createBNF(g);
                this.productions.addAll(repeat.productions);
                EBNFProduction p4 = Join.addProduction(g, this, repetition, first, repeat.tgt);
                p4.setAstBuilder(astBuilder);
                p4.onExtension((parent, children) -> {
                    children[0].setName(this.getNameForChild(0));
                    children[1].setName("repeat");
                });
                Join.addProduction(g, this, repetition, Terminal.EPSILON).setAstBuilder((parent, children) -> {});
            } else {
                Repeat repeat = new Repeat(null, (Symbol)next, lower - 1, upper - 1);
                repeat.setParsedChildNames("next");
                repeat.createBNF(g);
                this.productions.addAll(repeat.productions);
                EBNFProduction p5 = Join.addProduction(g, this, repetition, first, repeat.tgt);
                p5.setAstBuilder(astBuilder);
                p5.onExtension((parent, children) -> {
                    children[0].setName(this.getNameForChild(0));
                    children[1].setName("repeat");
                });
            }
        }
        if (!hasOpen && !hasClose) {
            EBNFProduction p6 = Join.addProduction(g, this, this.tgt, repetition);
            p6.onExtension((parent, children) -> children[0].setName("repetition"));
            p6.setAstBuilder((parent, children) -> parent.addChildren(children[0].getChildren()));
        } else {
            EBNFProduction p7 = Join.addProduction(g, this, this.tgt, this.open, repetition, this.close);
            p7.onExtension((parent, children) -> {
                if (!this.onlyKeepEntries) {
                    children[0].setName("open");
                }
                children[1].setName("repetition");
                if (!this.onlyKeepEntries) {
                    children[2].setName("close");
                }
            });
            p7.setAstBuilder((parent, children) -> {
                if (!this.onlyKeepEntries) {
                    parent.addChildren(children[0]);
                }
                parent.addChildren(children[1].getChildren());
                if (!this.onlyKeepEntries) {
                    parent.addChildren(children[2]);
                }
            });
        }
    }
}

