/*
 * Decompiled with CFR 0.152.
 */
package nlScript.ebnf;

import nlScript.Evaluator;
import nlScript.ParsedNode;
import nlScript.core.BNF;
import nlScript.core.NonTerminal;
import nlScript.core.Production;
import nlScript.core.Symbol;
import nlScript.ebnf.EBNFProduction;
import nlScript.ebnf.Rule;

public class Repeat
extends Rule {
    private final int from;
    private final int to;

    public Repeat(NonTerminal tgt, Symbol child, int from, int to) {
        super("repeat", tgt, child);
        this.from = from;
        this.to = to;
        this.setEvaluator(Evaluator.ALL_CHILDREN_EVALUATOR);
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public Symbol getEntry() {
        return this.children[0];
    }

    @Override
    public void createBNF(BNF g) {
        for (int seqLen = this.to; seqLen >= this.from; --seqLen) {
            Symbol[] rhs = new Symbol[seqLen];
            for (int i = 0; i < seqLen; ++i) {
                rhs[i] = this.children[0];
            }
            EBNFProduction p = Repeat.addProduction(g, this, this.tgt, rhs);
            p.onExtension((parent, children) -> {
                for (int c = 0; c < children.length; ++c) {
                    ParsedNode ch = (ParsedNode)children[c];
                    ch.setNthEntryInParent(c);
                    ch.setName(this.getNameForChild(c));
                }
            });
            p.setAstBuilder(Production.AstBuilder.DEFAULT);
        }
    }
}

