/*
 * Decompiled with CFR 0.152.
 */
package nlScript.ui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import nlScript.ParseException;
import nlScript.ParsedNode;
import nlScript.Parser;
import nlScript.core.GraphViz;
import nlScript.ui.ACProvider;
import nlScript.ui.AutocompletionContext;
import nlScript.ui.TextLineNumber;

public class ACEditor {
    private final JFrame frame;
    private final JTextComponent textArea;
    private final JTextComponent outputArea;
    private final AutocompletionContext autocompletionContext;
    private final Parser parser;
    private final JButton runButton;
    private final JPanel buttonsPanel;
    private Thread runThread = null;
    private ActionListener onRun = e -> this.run();
    private Runnable beforeRun = () -> {};
    private Runnable afterRun = () -> {};

    public ACEditor(Parser parser) {
        this.parser = parser;
        this.textArea = new JTextArea(20, 60);
        this.textArea.setFont(new Font("monospaced", 1, 12));
        JScrollPane textAreaScrollPane = new JScrollPane(this.textArea);
        TextLineNumber textLineNumber = new TextLineNumber(this.textArea);
        textAreaScrollPane.setRowHeaderView(textLineNumber);
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.add(textAreaScrollPane);
        this.outputArea = new JTextArea(5, 60);
        this.outputArea.setFont(new Font("monospaced", 0, 12));
        JScrollPane outputAreaScrollPane = new JScrollPane(this.outputArea);
        splitPane.add(outputAreaScrollPane);
        this.frame = new JFrame();
        this.frame.getContentPane().add(splitPane);
        this.buttonsPanel = new JPanel(new FlowLayout());
        this.runButton = new JButton("Run");
        this.runButton.addActionListener(this.onRun);
        this.buttonsPanel.add(this.runButton);
        this.frame.getContentPane().add((Component)this.buttonsPanel, "South");
        this.frame.pack();
        this.autocompletionContext = new AutocompletionContext(this.textArea, new ACProvider(parser));
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void setMenuBar(JMenuBar menuBar) {
        this.frame.setJMenuBar(menuBar);
        this.frame.pack();
    }

    public JPanel getButtonsPanel() {
        return this.buttonsPanel;
    }

    public void setOnRun(ActionListener l) {
        this.runButton.removeActionListener(this.onRun);
        this.onRun = l;
        this.runButton.addActionListener(this.onRun);
    }

    public void setBeforeRun(Runnable r) {
        this.beforeRun = r;
    }

    public void setAfterRun(Runnable r) {
        this.afterRun = r;
    }

    public void run() {
        this.run(false);
    }

    public void run(final boolean selectedLines) {
        this.outputArea.setText("");
        this.runThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ACEditor.this.beforeRun.run();
                    String textToEvaluate = selectedLines ? ACEditor.this.getSelectedLines() : ACEditor.this.getText();
                    ParsedNode pn = ACEditor.this.parser.parse(textToEvaluate, null);
                    ACEditor.this.outputArea.setText(GraphViz.toVizDotLink(pn));
                    pn.evaluate();
                    ACEditor.this.afterRun.run();
                }
                catch (ParseException e) {
                    ACEditor.this.outputArea.setText(e.getMessage() + "\n\n" + GraphViz.toVizDot(e.getRoot()));
                }
                catch (Throwable e) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    ACEditor.this.outputArea.setText(pw.toString());
                    e.printStackTrace();
                }
            }
        });
        this.runThread.start();
    }

    public Thread getRunThread() {
        return this.runThread;
    }

    public void setVisible(boolean b) {
        this.frame.setVisible(b);
    }

    public JTextComponent getTextArea() {
        return this.textArea;
    }

    public JTextComponent getOutputArea() {
        return this.outputArea;
    }

    public JButton getRunButton() {
        return this.runButton;
    }

    public String getText() {
        return this.textArea.getText();
    }

    public int getSelectedLinesStart() {
        JTextArea jta = (JTextArea)this.textArea;
        int start = jta.getSelectionStart();
        try {
            start = jta.getLineStartOffset(jta.getLineOfOffset(start));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return start;
    }

    public String getSelectedLines() {
        if (!(this.textArea instanceof JTextArea)) {
            return this.textArea.getSelectedText();
        }
        JTextArea jta = (JTextArea)this.textArea;
        int start = jta.getSelectionStart();
        int end = jta.getSelectionEnd();
        try {
            start = jta.getLineStartOffset(jta.getLineOfOffset(start));
            end = jta.getLineEndOffset(jta.getLineOfOffset(end));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        try {
            return jta.getText(start, end - start);
        }
        catch (BadLocationException e) {
            return this.textArea.getSelectedText();
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            Parser parser = new Parser();
            parser.defineSentence("This is my favourite sentence.", e -> null);
            ACEditor editor = new ACEditor(parser);
            editor.setVisible(true);
        });
    }
}

