/*
 * Decompiled with CFR 0.152.
 */
package nlScript.ui;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import nlScript.ParseException;
import nlScript.core.Autocompletion;
import nlScript.core.BNF;
import nlScript.core.Matcher;
import nlScript.core.NonTerminal;
import nlScript.core.Symbol;
import nlScript.ui.ACPopup;
import nlScript.ui.ACProvider;
import nlScript.ui.HighlightPainter;
import nlScript.ui.ParameterizedCompletionContext;

public class AutocompletionContext
implements ParameterizedCompletionContext.ParameterChangeListener {
    private final JTextComponent tc;
    private final ACProvider provider;
    private final ACPopup popup;
    private final ErrorHighlight errorHighlight;
    private boolean insertAsFarAsPossible = true;
    private ParameterizedCompletionContext parameterizedCompletion = null;
    private boolean insertedByAutocompletion = false;
    private boolean insertedParameterizedAutocompletion = false;
    final AtomicBoolean justInserted = new AtomicBoolean(false);
    private int lastInsertionPosition = -1;

    public AutocompletionContext(final JTextComponent tc, ACProvider acProvider) {
        this.tc = tc;
        this.provider = acProvider;
        Window parent = SwingUtilities.getWindowAncestor(tc);
        this.popup = new ACPopup(parent);
        this.errorHighlight = new ErrorHighlight(tc);
        this.popup.addMouseListenerToList(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Autocompletion completion = AutocompletionContext.this.popup.getSelected();
                    if (completion != null) {
                        AutocompletionContext.this.hidePopup();
                        AutocompletionContext.this.insertCompletion(tc.getCaretPosition(), completion);
                    }
                    e.consume();
                }
            }
        });
        this.tc.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.isConsumed()) {
                    return;
                }
                if (AutocompletionContext.this.popup.isVisible()) {
                    int kc = e.getKeyCode();
                    if (kc == 40 || kc == 39) {
                        AutocompletionContext.this.popup.next();
                        e.consume();
                    }
                    if (kc == 38 || kc == 37) {
                        AutocompletionContext.this.popup.previous();
                        e.consume();
                    }
                    if (kc == 10) {
                        Autocompletion completion = AutocompletionContext.this.popup.getSelected();
                        if (completion != null) {
                            AutocompletionContext.this.hidePopup();
                            AutocompletionContext.this.insertCompletion(tc.getCaretPosition(), completion, true);
                        }
                        e.consume();
                    }
                    if (kc == 27) {
                        e.consume();
                        AutocompletionContext.this.hidePopup();
                    }
                } else if (AutocompletionContext.this.parameterizedCompletion != null) {
                    if (e.getKeyCode() == 27) {
                        AutocompletionContext.this.cancelParameterizedCompletion();
                    }
                } else if (e.getKeyCode() == 32 && e.isControlDown()) {
                    AutocompletionContext.this.doAutocompletion(tc.getCaretPosition(), true);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        tc.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                int caret = e.getOffset() + e.getLength();
                AutocompletionContext.this.justInserted.set(true);
                if (!AutocompletionContext.this.insertedByAutocompletion || AutocompletionContext.this.insertAsFarAsPossible) {
                    if (AutocompletionContext.this.insertedParameterizedAutocompletion) {
                        return;
                    }
                    AutocompletionContext.this.doAutocompletion(caret, true);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AutocompletionContext.this.hidePopup();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        tc.addCaretListener(e -> {
            if (!this.justInserted.get()) {
                this.hidePopup();
            } else {
                this.justInserted.set(false);
            }
        });
        parent.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                AutocompletionContext.this.hidePopup();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                AutocompletionContext.this.hidePopup();
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                AutocompletionContext.this.hidePopup();
            }
        });
    }

    public void insertCompletion(int caret, Autocompletion completion) {
        this.insertCompletion(caret, completion, false);
    }

    public void insertCompletion(int caret, Autocompletion completion, boolean force) {
        String repl = completion.getCompletion(Autocompletion.Purpose.FOR_INSERTION);
        String alreadyEntered = completion.getAlreadyEntered();
        if (!force && caret == this.lastInsertionPosition) {
            return;
        }
        this.lastInsertionPosition = caret;
        this.tc.moveCaretPosition(caret - alreadyEntered.length());
        this.insertedByAutocompletion = true;
        if (repl.contains("${")) {
            this.cancelParameterizedCompletion();
            this.insertedParameterizedAutocompletion = true;
            this.parameterizedCompletion = new ParameterizedCompletionContext(this.tc);
            this.parameterizedCompletion.addParameterChangeListener(this);
            this.parameterizedCompletion.replaceSelection(completion);
            this.insertedParameterizedAutocompletion = false;
        } else {
            this.tc.replaceSelection(repl);
        }
        this.insertedByAutocompletion = false;
    }

    @Override
    public void parameterChanged(ParameterizedCompletionContext source, int pIdx, boolean wasLast) {
        if (source != this.parameterizedCompletion) {
            this.cancelParameterizedCompletion();
            new Exception().printStackTrace();
            return;
        }
        this.justInserted.set(true);
        if (wasLast) {
            this.parameterizedCompletion = null;
            this.doAutocompletion(this.tc.getCaretPosition(), true);
            return;
        }
        if (pIdx == -1) {
            this.parameterizedCompletion = null;
            this.doAutocompletion(this.tc.getCaretPosition(), true);
            return;
        }
        if (this.parameterizedCompletion.getParameter((int)pIdx).parameterizedCompletion.autocompleteOnActivation()) {
            this.doAutocompletion(this.tc.getCaretPosition(), false);
            return;
        }
        List<Autocompletion> completions = this.parameterizedCompletion.getParameter((int)pIdx).allOptions;
        this.popup.getModel().set(completions);
        if (completions.size() < 2) {
            this.hidePopup();
        } else {
            this.popup.setSelectedIndex(0);
            this.showPopup(this.tc.getCaretPosition());
        }
    }

    public void hidePopup() {
        if (this.popup.isVisible()) {
            this.popup.setVisible(false);
        }
    }

    public void cancelParameterizedCompletion() {
        if (this.parameterizedCompletion != null) {
            this.parameterizedCompletion.finish(false);
        }
        this.parameterizedCompletion = null;
    }

    public void showPopup(int caret) {
        Rectangle r;
        if (this.popup.isVisible()) {
            return;
        }
        try {
            r = this.tc.modelToView(caret);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
            return;
        }
        Point p = new Point(r.x, r.y);
        SwingUtilities.convertPointToScreen(p, this.tc);
        r.x = p.x;
        r.y = p.y;
        this.popup.setLocationRelativeTo(r);
        this.popup.setVisible(true);
    }

    public void doAutocompletion(int caret, boolean autoInsertSingleOption) {
        List<Autocompletion> completions;
        String entireText = this.tc.getText();
        String text = entireText.substring(0, caret);
        this.errorHighlight.clearError();
        try {
            completions = this.provider.getAutocompletions(text);
        }
        catch (ParseException e) {
            Matcher f = e.getFirstAutocompletingAncestorThatFailed().getMatcher();
            this.errorHighlight.setError(f.pos, f.pos + f.parsed.length());
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            completions = new ArrayList<Autocompletion>();
        }
        BNF bnf = this.provider.getParser().getTargetGrammar().getBNF();
        if (this.parameterizedCompletion != null && !completions.isEmpty()) {
            boolean atLeastOnCompletionForCurrentParameter = false;
            for (Autocompletion comp : completions) {
                Symbol symbol = comp.forSymbol;
                if (comp instanceof Autocompletion.EntireSequence) {
                    ArrayList<ParameterizedCompletionContext.ParsedParam> tmp = new ArrayList<ParameterizedCompletionContext.ParsedParam>();
                    ParameterizedCompletionContext.parseParameters((Autocompletion.EntireSequence)comp, tmp, 0);
                    comp = tmp.get((int)0).parameterizedCompletion;
                    symbol = comp.forSymbol;
                }
                if (symbol.equals(this.parameterizedCompletion.getForAutocompletion().forSymbol)) {
                    atLeastOnCompletionForCurrentParameter = true;
                    break;
                }
                Symbol parameterSymbol = this.parameterizedCompletion.getCurrentParameter().parameterizedCompletion.forSymbol;
                if (symbol.equals(parameterSymbol)) {
                    atLeastOnCompletionForCurrentParameter = true;
                    break;
                }
                if (!(parameterSymbol instanceof NonTerminal) || !((NonTerminal)parameterSymbol).uses(symbol, bnf)) continue;
                atLeastOnCompletionForCurrentParameter = true;
                break;
            }
            if (!atLeastOnCompletionForCurrentParameter) {
                SwingUtilities.invokeLater(() -> this.parameterizedCompletion.next());
                return;
            }
        }
        this.popup.getModel().set(completions);
        if (completions.size() < 2) {
            if (this.popup.getModel().getSize() == 1) {
                Autocompletion completion = this.popup.getModel().getElementAt(0);
                if (autoInsertSingleOption || completion instanceof Autocompletion.Literal) {
                    SwingUtilities.invokeLater(() -> {
                        boolean tmp = this.insertAsFarAsPossible;
                        if (caret < entireText.trim().length()) {
                            this.insertAsFarAsPossible = false;
                        }
                        this.insertCompletion(caret, completion);
                        this.insertAsFarAsPossible = tmp;
                    });
                }
            }
            this.hidePopup();
            return;
        }
        this.popup.setSelectedIndex(0);
        this.showPopup(caret);
    }

    private static class ErrorHighlight {
        private final HighlightPainter errorHighlight = new HighlightPainter.Squiggle(new Color(255, 100, 100));
        private final JTextComponent tc;
        private Object highlightTag;

        public ErrorHighlight(JTextComponent tc) {
            this.tc = tc;
        }

        void setError(int i0, int i1) {
            this.clearError();
            try {
                int start = i0 == 0 ? 0 : i0 - 1;
                this.highlightTag = this.tc.getHighlighter().addHighlight(start, i1, this.errorHighlight);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        void clearError() {
            if (this.highlightTag != null) {
                this.tc.getHighlighter().removeHighlight(this.highlightTag);
                this.highlightTag = null;
            }
        }
    }
}

