/*
 * Decompiled with CFR 0.152.
 */
package nlScript.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.text.Element;

public class LineNumberingTextArea
extends JTextArea {
    private JTextArea textArea;

    public LineNumberingTextArea(JTextArea textArea) {
        this.textArea = textArea;
        this.setBorder(new CompoundBorder(new MatteBorder(0, 0, 0, 1, new Color(221, 221, 221)), new EmptyBorder(new Insets(0, 5, 0, 5))));
        this.setFont(textArea.getFont());
        this.setBackground(new Color(245, 245, 245));
        this.setForeground(new Color(108, 108, 108));
        this.setEditable(false);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.width = this.getFontMetrics(this.getFont()).stringWidth("9") * 5;
        return d;
    }

    public void updateLineNumbers() {
        String lineNumbersText = this.getLineNumbersText();
        this.setText(lineNumbersText);
    }

    private String getLineNumbersText() {
        int caretPosition = this.textArea.getDocument().getLength();
        Element root = this.textArea.getDocument().getDefaultRootElement();
        StringBuilder lineNumbersTextBuilder = new StringBuilder();
        lineNumbersTextBuilder.append("1").append(System.lineSeparator());
        for (int elementIndex = 2; elementIndex < root.getElementIndex(caretPosition) + 2; ++elementIndex) {
            lineNumbersTextBuilder.append(elementIndex).append(System.lineSeparator());
        }
        return lineNumbersTextBuilder.toString();
    }
}

