/*
 * Decompiled with CFR 0.152.
 */
package nlScript.util;

import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class CompletePath {
    static HashMap<Path, Path[]> filesystemCache = new HashMap();

    public static void clearFilesystemCache() {
        filesystemCache.clear();
    }

    static Path getParent(String alreadyEntered) {
        Path p = Paths.get(alreadyEntered, new String[0]);
        if (!p.isAbsolute()) {
            return null;
        }
        if (alreadyEntered.endsWith(FileSystems.getDefault().getSeparator()) || alreadyEntered.endsWith("/")) {
            return p;
        }
        return p.getParent();
    }

    static Path getChild(String alreadyEntered) {
        Path child = Paths.get(alreadyEntered, new String[0]);
        Path parent = CompletePath.getParent(alreadyEntered);
        if (parent == null) {
            return child;
        }
        return parent.relativize(child);
    }

    static String getFileName(Path path) {
        Path name = path.getFileName();
        if (name != null) {
            return name.toString();
        }
        return path.toString();
    }

    static boolean isHidden(Path path) {
        try {
            return CompletePath.getFileName(path).startsWith(".") || Files.isHidden(path) || (Boolean)Files.getAttribute(path, "dos:hidden", new LinkOption[0]) != false;
        }
        catch (Exception e) {
            return false;
        }
    }

    static String[] getSiblings(String alreadyEntered) {
        Path parent = CompletePath.getParent(alreadyEntered);
        Path child = CompletePath.getChild(alreadyEntered);
        Path[] siblingsArray = filesystemCache.get(parent);
        if (siblingsArray == null) {
            try {
                Stream<Path> siblings = parent == null ? StreamSupport.stream(FileSystems.getDefault().getRootDirectories().spliterator(), true) : Files.list(parent);
                siblingsArray = (Path[])siblings.toArray(Path[]::new);
                filesystemCache.put(parent, siblingsArray);
            }
            catch (Exception e) {
                return new String[0];
            }
        }
        return (String[])Arrays.stream(siblingsArray).filter(p -> CompletePath.getFileName(p).toLowerCase().startsWith(child.toString().toLowerCase())).map(x$0 -> new PathWrapper((Path)x$0)).sorted((o1, o2) -> {
            if (((PathWrapper)o1).isHidden && !((PathWrapper)o2).isHidden) {
                return 1;
            }
            if (((PathWrapper)o2).isHidden && !((PathWrapper)o1).isHidden) {
                return -1;
            }
            if (((PathWrapper)o1).isDirectory && !((PathWrapper)o2).isDirectory) {
                return -1;
            }
            if (((PathWrapper)o2).isDirectory && !((PathWrapper)o1).isDirectory) {
                return 1;
            }
            return ((PathWrapper)o1).name.compareTo(((PathWrapper)o2).name);
        }).map(p -> {
            String s = ((PathWrapper)p).path.toString();
            if (((PathWrapper)p).isDirectory) {
                s = s + FileSystems.getDefault().getSeparator();
            }
            return s;
        }).toArray(String[]::new);
    }

    public static String[] getCompletion(String alreadyEntered) {
        String[] siblings = CompletePath.getSiblings(alreadyEntered);
        if (siblings.length == 0) {
            return new String[]{alreadyEntered};
        }
        return siblings;
    }

    private static void testFileName() {
        Path p = Paths.get("c:\\", new String[0]);
        System.out.println(CompletePath.getFileName(p));
        p = Paths.get("c:", new String[0]);
        System.out.println(CompletePath.getFileName(p));
        p = Paths.get("c", new String[0]);
        System.out.println(CompletePath.getFileName(p));
        p = Paths.get("c:\\users", new String[0]);
        System.out.println(CompletePath.getFileName(p));
        p = Paths.get("c:\\users\\", new String[0]);
        System.out.println(CompletePath.getFileName(p));
        p = Paths.get("c:/users", new String[0]);
        System.out.println(CompletePath.getFileName(p));
        p = Paths.get("c:/users/", new String[0]);
        System.out.println(CompletePath.getFileName(p));
    }

    public static void main(String[] args) {
        CompletePath.testFileName();
    }

    private static class PathWrapper {
        private final boolean isHidden;
        private final boolean isDirectory;
        private final Path path;
        private final String name;

        private PathWrapper(Path path) {
            this.path = path;
            this.name = CompletePath.getFileName(path);
            this.isHidden = CompletePath.isHidden(path);
            this.isDirectory = Files.isDirectory(path, new LinkOption[0]);
        }
    }
}

