/*
 * Decompiled with CFR 0.152.
 */
package nlScript;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import nlScript.Autocompleter;
import nlScript.Evaluator;
import nlScript.ParseException;
import nlScript.ParsedNode;
import nlScript.core.Autocompletion;
import nlScript.core.BNF;
import nlScript.core.DefaultParsedNode;
import nlScript.core.Generation;
import nlScript.core.GeneratorHints;
import nlScript.core.Lexer;
import nlScript.core.Named;
import nlScript.core.NonTerminal;
import nlScript.core.ParseDebugger;
import nlScript.core.ParsingState;
import nlScript.core.RDParser;
import nlScript.core.Symbol;
import nlScript.core.Terminal;
import nlScript.ebnf.EBNF;
import nlScript.ebnf.EBNFParsedNodeFactory;
import nlScript.ebnf.EBNFParser;
import nlScript.ebnf.Join;
import nlScript.ebnf.NamedRule;
import nlScript.ebnf.Rule;
import nlScript.util.Range;

public class Parser {
    private final EBNF grammar = new EBNF();
    private final Terminal LINEBREAK = Terminal.literal("\n");
    public final Rule QUANTIFIER;
    public final Rule IDENTIFIER;
    public final Rule VARIABLE_NAME;
    public final Rule ENTRY_NAME;
    public final Rule LIST;
    public final Rule TUPLE;
    public final Rule CHARACTER_CLASS;
    public final Rule TYPE;
    public final Rule VARIABLE;
    public final Rule NO_VARIABLE;
    public final Rule EXPRESSION;
    public final Rule PROGRAM;
    private final Rule LINEBREAK_STAR;
    private final EBNF targetGrammar = new EBNF();
    private final HashMap<String, ArrayList<Autocompletion>> symbol2Autocompletion = new HashMap();
    private boolean compiled = false;
    private final ArrayList<EBNFParser.ParseStartListener> parseStartListeners = new ArrayList();

    public Parser() {
        this.QUANTIFIER = this.quantifier();
        this.IDENTIFIER = this.identifier("identifier");
        this.VARIABLE_NAME = this.variableName();
        this.ENTRY_NAME = this.entryName();
        this.LIST = this.list();
        this.TUPLE = this.tuple();
        this.CHARACTER_CLASS = this.characterClass();
        this.TYPE = this.type();
        this.VARIABLE = this.variable();
        this.NO_VARIABLE = this.noVariable();
        this.EXPRESSION = this.expression();
        this.LINEBREAK_STAR = this.targetGrammar.star("linebreak-star", this.LINEBREAK.withName());
        this.PROGRAM = this.program();
    }

    public EBNF getGrammar() {
        return this.grammar;
    }

    public EBNF getTargetGrammar() {
        return this.targetGrammar;
    }

    public NamedRule defineSentence(String pattern, Evaluator evaluator) {
        return this.defineSentence(pattern, evaluator, null);
    }

    public NamedRule defineSentence(String pattern, Evaluator evaluator, boolean completeEntireSequence) {
        Autocompleter autocompleter = completeEntireSequence ? new Autocompleter.EntireSequenceCompleter(this.targetGrammar, this.symbol2Autocompletion) : Autocompleter.DEFAULT_INLINE_AUTOCOMPLETER;
        return this.defineSentence(pattern, evaluator, autocompleter);
    }

    public NamedRule defineSentence(String pattern, Evaluator evaluator, Autocompleter autocompleter) {
        return this.defineType("sentence", pattern, evaluator, autocompleter);
    }

    public NamedRule defineType(String type, String pattern, Evaluator evaluator) {
        return this.defineType(type, pattern, evaluator, null);
    }

    public NamedRule defineType(String type, String pattern, Evaluator evaluator, boolean completeEntireSequence) {
        Autocompleter autocompleter = completeEntireSequence ? new Autocompleter.EntireSequenceCompleter(this.targetGrammar, this.symbol2Autocompletion) : Autocompleter.DEFAULT_INLINE_AUTOCOMPLETER;
        return this.defineType(type, pattern, evaluator, autocompleter);
    }

    public NamedRule defineType(String type, String pattern, Evaluator evaluator, Autocompleter autocompleter) {
        DefaultParsedNode pn;
        this.grammar.compile(this.EXPRESSION.getTarget());
        RDParser parser = new RDParser(this.grammar.getBNF(), new Lexer(pattern), EBNFParsedNodeFactory.INSTANCE);
        try {
            pn = parser.parse();
        }
        catch (ParseException e) {
            throw new RuntimeException("Parsing failed", e);
        }
        if (pn.getMatcher().state != ParsingState.SUCCESSFUL) {
            throw new RuntimeException("Parsing failed");
        }
        Named[] rhs = (Named[])pn.evaluate();
        Rule newRule = this.targetGrammar.sequence(type, rhs);
        if (evaluator != null) {
            newRule.setEvaluator(evaluator);
        }
        if (autocompleter != null) {
            newRule.setAutocompleter(autocompleter);
        }
        return newRule.withName(type);
    }

    public void undefineType(String type) {
        NonTerminal unitsSymbol = (NonTerminal)this.targetGrammar.getSymbol(type);
        this.targetGrammar.removeRules(unitsSymbol);
        this.compiled = false;
    }

    public void compile() {
        this.compile(this.targetGrammar.getSymbol("program"));
    }

    public void compile(Symbol symbol) {
        this.targetGrammar.compile(symbol);
        this.compiled = true;
    }

    public ParsedNode parse(String text, ArrayList<Autocompletion> autocompletions) throws ParseException {
        return this.parse(text, autocompletions, false);
    }

    public ParsedNode parse(String text, ArrayList<Autocompletion> autocompletions, boolean debug) throws ParseException {
        if (!this.compiled) {
            this.compile();
        }
        this.symbol2Autocompletion.clear();
        BNF grammar = this.targetGrammar.getBNF();
        EBNFParser rdParser = new EBNFParser(grammar, new Lexer(text));
        if (debug) {
            ParseDebugger debugger = new ParseDebugger();
            rdParser.setParseDebugger(debugger);
        }
        rdParser.addParseStartListener(this::fireParsingStarted);
        return (ParsedNode)rdParser.parse(autocompletions);
    }

    public Generation generate(Rule rule) {
        return rule.generate(this.targetGrammar);
    }

    public Generation generate() {
        return this.PROGRAM.generate(this.targetGrammar);
    }

    public void setGeneratorHints(NamedRule rule, GeneratorHints hints) {
        ((Rule)rule.get()).setGeneratorHints(hints);
    }

    public void setGeneratorHints(NamedRule rule, String children, GeneratorHints hints) {
        Object[] child = children.split("::");
        String[] allButLast = new String[child.length - 1];
        String lastChildName = child[child.length - 1];
        System.arraycopy(child, 0, allButLast, 0, allButLast.length);
        List<Rule> parents = this.getChildRules((Rule)rule.get(), allButLast);
        boolean atLeastOne = false;
        for (Rule parent : parents) {
            if (!parent.hasParsedName(lastChildName)) continue;
            atLeastOne = true;
            parent.setChildGeneratorHints(lastChildName, hints);
        }
        if (!atLeastOne) {
            throw new RuntimeException("Cannot set generator hints for child " + Arrays.toString(child) + " (no child with that name)");
        }
    }

    private List<Rule> getChildRules(Rule rule, String ... children) {
        ArrayList<Rule> currentLevel = new ArrayList<Rule>();
        currentLevel.add(rule);
        for (String childName : children) {
            ArrayList<Rule> nextLevel = new ArrayList<Rule>();
            for (Rule r : currentLevel) {
                if (!r.hasParsedName(childName)) continue;
                for (Named<?> child : r.getChildren()) {
                    Symbol childSymbol = child.getSymbol();
                    if (!(childSymbol instanceof NonTerminal)) continue;
                    ArrayList<Rule> rulesForChild = this.targetGrammar.getRules((NonTerminal)childSymbol);
                    nextLevel.addAll(rulesForChild);
                }
            }
            currentLevel = nextLevel;
        }
        return currentLevel;
    }

    private Rule quantifier() {
        return this.grammar.or("quantifier", this.grammar.sequence(null, Terminal.literal("?").withName()).setEvaluator(pn -> Range.OPTIONAL).withName("optional"), this.grammar.sequence(null, Terminal.literal("+").withName()).setEvaluator(pn -> Range.PLUS).withName("plus"), this.grammar.sequence(null, Terminal.literal("*").withName()).setEvaluator(pn -> Range.STAR).withName("star"), this.grammar.sequence(null, this.grammar.INTEGER_RANGE.withName("range")).setEvaluator(pn -> pn.evaluate(0)).withName("range"), this.grammar.sequence(null, this.grammar.INTEGER.withName("int")).setEvaluator(pn -> new Range((Integer)pn.evaluate(0))).withName("fixed"));
    }

    private Rule identifier(String name) {
        if (name == null) {
            name = "identifier";
        }
        return this.grammar.sequence(name, Terminal.characterClass("[A-Za-z_]").withName(), this.grammar.optional(null, this.grammar.sequence(null, this.grammar.star(null, Terminal.characterClass("[A-Za-z0-9_-]").withName()).withName("star"), Terminal.characterClass("[A-Za-z0-9_]").withName()).withName("seq")).withName("opt"));
    }

    private Rule variableName() {
        return this.grammar.plus("var-name", Terminal.characterClass("[^:{}]").withName()).setEvaluator(Evaluator.DEFAULT_EVALUATOR);
    }

    private Rule entryName() {
        return this.identifier("entry-name");
    }

    private Rule list() {
        return this.grammar.sequence("list", Terminal.literal("list").withName(), this.grammar.WHITESPACE_STAR.withName("ws*"), Terminal.literal("<").withName(), this.grammar.WHITESPACE_STAR.withName("ws*"), this.IDENTIFIER.withName("type"), this.grammar.WHITESPACE_STAR.withName("ws*"), Terminal.literal(">").withName()).setEvaluator(pn -> {
            String identifier = (String)pn.evaluate("type");
            Symbol entry = this.targetGrammar.getSymbol(identifier);
            Named<Symbol> namedEntry = entry instanceof Terminal ? ((Terminal)entry).withName(identifier) : ((NonTerminal)entry).withName(identifier);
            return this.targetGrammar.list(null, namedEntry);
        });
    }

    private Rule tuple() {
        return this.grammar.sequence("tuple", Terminal.literal("tuple").withName(), this.grammar.WHITESPACE_STAR.withName("ws*"), Terminal.literal("<").withName(), this.grammar.WHITESPACE_STAR.withName("ws*"), this.IDENTIFIER.withName("type"), this.grammar.plus(null, this.grammar.sequence(null, this.grammar.WHITESPACE_STAR.withName("ws*"), Terminal.literal(",").withName(), this.grammar.WHITESPACE_STAR.withName("ws*"), this.ENTRY_NAME.withName("entry-name"), this.grammar.WHITESPACE_STAR.withName("ws*")).withName("sequence-names")).withName("plus-names"), Terminal.literal(">").withName()).setEvaluator(pn -> {
            String type = (String)pn.evaluate("type");
            DefaultParsedNode plus = pn.getChild("plus-names");
            int nTuple = plus.numChildren();
            String[] entryNames = new String[nTuple];
            for (int i = 0; i < nTuple; ++i) {
                entryNames[i] = (String)plus.getChild(i).evaluate("entry-name");
            }
            Symbol entry = this.targetGrammar.getSymbol(type);
            Named<Symbol> namedEntry = entry instanceof Terminal ? ((Terminal)entry).withName() : ((NonTerminal)entry).withName();
            return this.targetGrammar.tuple(null, namedEntry, entryNames).getTarget();
        });
    }

    private Rule characterClass() {
        return this.grammar.sequence("character-class", Terminal.literal("[").withName(), this.grammar.plus(null, this.grammar.or(null, Terminal.characterClass("[^]]").withName(), Terminal.literal("\\]").withName()).withName()).withName("plus"), Terminal.literal("]").withName()).setEvaluator(pn -> {
            String pattern = pn.getParsedString();
            return Terminal.characterClass(pattern);
        });
    }

    private Rule type() {
        return this.grammar.or("type", this.grammar.sequence(null, this.IDENTIFIER.withName("identifier")).setEvaluator(pn -> {
            String str = pn.getParsedString();
            Symbol symbol = this.targetGrammar.getSymbol(str);
            if (symbol == null) {
                throw new RuntimeException("Unknown type '" + str + "'");
            }
            return symbol;
        }).withName("type"), this.LIST.withName("list"), this.TUPLE.withName("tuple"), this.CHARACTER_CLASS.withName("character-class"));
    }

    private Rule variable() {
        return this.grammar.sequence("variable", Terminal.literal("{").withName(), this.VARIABLE_NAME.withName("variable-name"), this.grammar.optional(null, this.grammar.sequence(null, Terminal.literal(":").withName(), this.TYPE.withName("type")).withName("seq-type")).withName("opt-type"), this.grammar.optional(null, this.grammar.sequence(null, Terminal.literal(":").withName(), this.QUANTIFIER.withName("quantifier")).withName("seq-quantifier")).withName("opt-quantifier"), Terminal.literal("}").withName()).setEvaluator(pn -> {
            Named<Symbol> namedSymbol;
            String variableName = (String)pn.evaluate("variable-name");
            Object typeObject = pn.evaluate("opt-type", "seq-type", "type");
            Object quantifierObject = pn.evaluate("opt-quantifier", "seq-quantifier", "quantifier");
            if (typeObject instanceof Join) {
                Join join = (Join)typeObject;
                if (quantifierObject != null) {
                    join.setCardinality((Range)quantifierObject);
                }
                return join.withName(variableName);
            }
            Symbol symbol = typeObject == null ? Terminal.literal(variableName) : (Symbol)typeObject;
            Named<Symbol> named = namedSymbol = symbol instanceof Terminal ? ((Terminal)symbol).withName(variableName) : ((NonTerminal)symbol).withName(variableName);
            if (quantifierObject != null) {
                Range range;
                Autocompleter autocompleter = null;
                if (typeObject instanceof Terminal) {
                    autocompleter = Autocompleter.DEFAULT_INLINE_AUTOCOMPLETER;
                }
                symbol = (range = (Range)quantifierObject).equals(Range.STAR) ? this.targetGrammar.star(null, namedSymbol).setAutocompleter(autocompleter).getTarget() : (range.equals(Range.PLUS) ? this.targetGrammar.plus(null, namedSymbol).setAutocompleter(autocompleter).getTarget() : (range.equals(Range.OPTIONAL) ? this.targetGrammar.optional(null, namedSymbol).setAutocompleter(autocompleter).getTarget() : this.targetGrammar.repeat(null, namedSymbol, range.getLower(), range.getUpper()).setAutocompleter(autocompleter).getTarget()));
                namedSymbol = ((NonTerminal)symbol).withName(variableName);
            }
            return namedSymbol;
        });
    }

    private Rule noVariable() {
        return this.grammar.sequence("no-variable", Terminal.characterClass("[^ \t\n{]").withName(), this.grammar.optional("no-var-tail-opt", this.grammar.sequence("no-var-tail-opt-seq", this.grammar.star("no-var-tail-opt-seq-star", Terminal.characterClass("[^{\n]").withName()).withName("middle"), Terminal.characterClass("[^ \t\n{]").withName()).withName("seq")).withName("tail")).setEvaluator(pn -> Terminal.literal(pn.getParsedString()).withName());
    }

    private Rule expression() {
        return this.grammar.join("expression", this.grammar.or("var-or-novar", this.NO_VARIABLE.withName("no-variable"), this.VARIABLE.withName("variable")).withName("or"), null, null, this.grammar.WHITESPACE_STAR.withName("delimiter"), false, Range.PLUS).setEvaluator(parsedNode -> {
            int nChildren = parsedNode.numChildren();
            ArrayList<Named> rhsList = new ArrayList<Named>();
            rhsList.add((Named)parsedNode.evaluate(0));
            for (int i = 1; i < nChildren; ++i) {
                boolean hasWS;
                DefaultParsedNode child = parsedNode.getChild(i);
                if (i % 2 == 0) {
                    rhsList.add((Named)child.evaluate());
                    continue;
                }
                boolean bl = hasWS = child.numChildren() > 0;
                if (!hasWS) continue;
                rhsList.add(this.targetGrammar.WHITESPACE_PLUS.withName("ws+"));
            }
            Named[] rhs = new Named[rhsList.size()];
            rhsList.toArray(rhs);
            return rhs;
        });
    }

    private Rule program() {
        return this.targetGrammar.join("program", new NonTerminal("sentence").withName("sentence"), this.LINEBREAK_STAR.withName("open"), this.LINEBREAK_STAR.withName("close"), this.LINEBREAK_STAR.withName("delimiter"), Range.STAR);
    }

    public void addParseStartListener(EBNFParser.ParseStartListener l) {
        this.parseStartListeners.add(l);
    }

    public void removeParseStartListener(EBNFParser.ParseStartListener l) {
        this.parseStartListeners.remove(l);
    }

    private void fireParsingStarted() {
        for (EBNFParser.ParseStartListener l : this.parseStartListeners) {
            l.parsingStarted();
        }
    }
}

