/*
 * Decompiled with CFR 0.152.
 */
package nlScript.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Generation {
    private final ArrayList<Generation> children = new ArrayList();
    private final String generatedText;
    private String name;

    public Generation(String text, Generation ... children) {
        this.generatedText = text;
        this.children.addAll(Arrays.asList(children));
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<Generation> getChildren() {
        return this.children;
    }

    public Generation getChild(int i) {
        return this.children.get(i);
    }

    public Generation getChild(String name) {
        for (Generation n : this.children) {
            if (!name.equals(n.getName())) continue;
            return n;
        }
        return null;
    }

    public String toString() {
        return this.generatedText;
    }

    public String getGeneratedText(String ... names) {
        Generation pn = this;
        for (String name : names) {
            if ((pn = pn.getChild(name)) != null) continue;
            return "";
        }
        return pn.generatedText;
    }
}

