/*
 * Decompiled with CFR 0.152.
 */
package nlScript.core;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import nlScript.Evaluator;
import nlScript.ParseException;
import nlScript.Parser;
import nlScript.core.BNF;
import nlScript.core.DefaultParsedNode;
import nlScript.core.IParseDebugger;
import nlScript.core.Lexer;
import nlScript.core.Matcher;
import nlScript.core.ParsedNodeFactory;
import nlScript.core.ParsingState;
import nlScript.core.RDParser;
import nlScript.core.Symbol;
import nlScript.core.Terminal;
import nlScript.ebnf.EBNF;
import nlScript.ebnf.Rule;
import nlScript.util.Range;

public class ParseDebugger
implements IParseDebugger {
    private DynamicJTree tree;
    private String text;
    private JFrame frame = null;
    private JSplitPane split = null;
    private JEditorPane parsedTextArea;
    private JLabel productionLabel;
    private JButton waitButton;
    private final HashMap<RDParser.SymbolSequence, DefaultMutableTreeNode> sequence2node = new HashMap();

    @Override
    public void reset(RDParser.SymbolSequence start, String text) {
        this.text = text;
        this.sequence2node.clear();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(start);
        this.sequence2node.put(start, root);
        this.tree = new DynamicJTree(root);
        this.show();
    }

    @Override
    public void nextTerminal(RDParser.SymbolSequence current, Matcher matcher, RDParser.SymbolSequence tip) {
        if (tip != null) {
            this.tree.nextNode = this.sequence2node.get(tip);
        }
        DefaultMutableTreeNode node = this.sequence2node.get(current);
        this.tree.treeModel.reload(node);
        SwingUtilities.invokeLater(() -> {
            this.tree.tree.scrollPathToVisible(new TreePath(node.getPath()));
            this.showDetailsFor(node);
        });
        this.pause();
    }

    @Override
    public void nextNonTerminal(RDParser.SymbolSequence current, RDParser.SymbolSequence next, RDParser.SymbolSequence tip) {
        DefaultMutableTreeNode parent = this.sequence2node.get(current);
        if (parent == null) {
            throw new RuntimeException("Cannot find node for " + current);
        }
        DefaultMutableTreeNode tmp = this.sequence2node.get(next);
        if (tmp != null) {
            throw new RuntimeException("Node for " + tmp + " already exists");
        }
        DefaultMutableTreeNode child = new DefaultMutableTreeNode(next);
        this.sequence2node.put(next, child);
        this.tree.add(parent, child);
        if (tip != null) {
            this.tree.nextNode = this.sequence2node.get(tip);
        }
        SwingUtilities.invokeLater(() -> {
            this.tree.tree.scrollPathToVisible(new TreePath(child.getPath()));
            this.showDetailsFor(child);
        });
        this.pause();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pause() {
        this.waitButton.setEnabled(true);
        Object lock = new Object();
        this.waitButton.addActionListener(l -> {
            Object object = lock;
            synchronized (object) {
                lock.notify();
            }
        });
        Object object = lock;
        synchronized (object) {
            try {
                lock.wait();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void show() {
        this.frame = new JFrame("Parse Debugger");
        this.frame.setDefaultCloseOperation(2);
        this.frame.setSize(400, 300);
        this.frame.setLayout(new BorderLayout());
        JPanel treePanel = new JPanel(new BorderLayout());
        JPanel detailsPanel = new JPanel();
        this.split = new JSplitPane(0, treePanel, detailsPanel);
        this.frame.add((Component)this.split, "Center");
        JScrollPane treeScrollPane = new JScrollPane(this.tree.tree);
        treePanel.add((Component)treeScrollPane, "Center");
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        detailsPanel.setLayout(gridbag);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.productionLabel = new JLabel();
        detailsPanel.add((Component)this.productionLabel, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.parsedTextArea = new JEditorPane("text/html", this.text);
        this.parsedTextArea.setEditable(false);
        detailsPanel.add((Component)new JScrollPane(this.parsedTextArea), c);
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new FlowLayout());
        this.waitButton = new JButton("Continue");
        this.waitButton.setEnabled(false);
        inputPanel.add(this.waitButton);
        this.frame.add((Component)inputPanel, "South");
        this.frame.setVisible(true);
        this.tree.tree.addTreeSelectionListener(e -> {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getPaths()[0].getLastPathComponent();
            if (node == null) {
                return;
            }
            this.showDetailsFor(node);
        });
    }

    public void showDetailsFor(DefaultMutableTreeNode node) {
        RDParser.SymbolSequence seq = (RDParser.SymbolSequence)node.getUserObject();
        this.productionLabel.setText("Production: " + seq.getProduction().toString());
        Matcher matcher = seq.getLastMatcher();
        int parsedUntil = seq.getParsedUntil();
        parsedUntil = Math.min(parsedUntil, this.text.length());
        String text = "<html><u><b color=\"blue\">" + ParseDebugger.escapeHTML(this.text.substring(0, parsedUntil)) + "</b></u>" + ParseDebugger.escapeHTML(this.text.substring(parsedUntil)) + "</html>";
        this.parsedTextArea.setText(text);
    }

    public static void main(String[] args) throws ParseException {
        Parser parser = new Parser();
        parser.defineSentence("T {x:digit:+} z.", e -> null);
        String text = "T abc z.";
        parser.parse(text, null);
    }

    public static void main2(String[] args) throws ParseException {
        EBNF grammar = new EBNF();
        Rule IDENTIFIER = grammar.sequence("identifier", Terminal.characterClass("[A-Za-z_]").withName(), grammar.optional(null, grammar.sequence(null, grammar.star(null, Terminal.characterClass("[A-Za-z0-9_-]").withName()).withName("star"), Terminal.characterClass("[A-Za-z0-9_]").withName()).withName("seq")).withName("opt"));
        Rule TYPE = grammar.or("type", grammar.sequence(null, IDENTIFIER.withName("identifier")).withName());
        Rule VARIABLE_NAME = grammar.plus("var-name", Terminal.characterClass("[^:{}]").withName()).setEvaluator(Evaluator.DEFAULT_EVALUATOR);
        Rule QUANTIFIER = grammar.or("quantifier", grammar.sequence(null, Terminal.literal("?").withName()).setEvaluator(pn -> Range.OPTIONAL).withName("optional"), grammar.sequence(null, Terminal.literal("+").withName()).setEvaluator(pn -> Range.PLUS).withName("plus"), grammar.sequence(null, Terminal.literal("*").withName()).setEvaluator(pn -> Range.STAR).withName("star"), grammar.sequence(null, grammar.INTEGER_RANGE.withName("range")).setEvaluator(pn -> pn.evaluate(0)).withName("range"), grammar.sequence(null, grammar.INTEGER.withName("int")).setEvaluator(pn -> new Range((Integer)pn.evaluate(0))).withName("fixed"));
        Rule r = grammar.sequence("variable", Terminal.literal("{").withName(), VARIABLE_NAME.withName("variable-name"), grammar.optional(null, grammar.sequence(null, Terminal.literal(":").withName(), TYPE.withName("type")).withName("seq-type")).withName("opt-type"), grammar.optional(null, grammar.sequence(null, Terminal.literal(":").withName(), QUANTIFIER.withName("quantifier")).withName("seq-quantifier")).withName("opt-quantifier"), Terminal.literal("}").withName());
        grammar.compile(r.getTarget());
        BNF bnf = grammar.getBNF();
        RDParser parser = new RDParser(bnf, new Lexer("{H:int:+}"), ParsedNodeFactory.DEFAULT);
        DefaultParsedNode parsed = parser.parse();
        if (ParsingState.SUCCESSFUL != parsed.getMatcher().state) {
            throw new RuntimeException();
        }
    }

    private static String escapeHTML(String html) {
        return html.replace("&", "&amp;").replace("\\", "&#39;").replace("\"", "&quot;").replace("<", "&lt;").replace(">", "&gt;");
    }

    private static class DynamicJTree {
        private final JTree tree;
        private final DefaultTreeModel treeModel;
        private DefaultMutableTreeNode nextNode = null;

        public DynamicJTree(DefaultMutableTreeNode root) {
            this.treeModel = new DefaultTreeModel(root);
            this.tree = new JTree(this.treeModel);
            DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer(){

                @Override
                public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    JLabel x;
                    Matcher matcher;
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                    RDParser.SymbolSequence seq = (RDParser.SymbolSequence)node.getUserObject();
                    JPanel panel = new JPanel();
                    if (selected) {
                        RoundedBorder b = new RoundedBorder(0);
                        b.setStroke(1);
                        b.setColor(Color.DARK_GRAY);
                        panel.setBorder(b);
                    }
                    FlowLayout layout = new FlowLayout();
                    layout.setHgap(5);
                    panel.setLayout(layout);
                    panel.setBackground(Color.white);
                    int newSymbolOffset = 0;
                    int newSymbolLength = 0;
                    if (seq.getParent() != null) {
                        newSymbolOffset = seq.getParent().getPos();
                        newSymbolLength = seq.getProduction().getRight().length;
                    }
                    if (node == nextNode) {
                        JLabel x2 = new JLabel(" -> ");
                        x2.setForeground(Color.WHITE);
                        x2.setBackground(Color.LIGHT_GRAY);
                        x2.setOpaque(true);
                        panel.add(x2);
                    }
                    if ((matcher = seq.getLastMatcher()) != null && matcher.state == ParsingState.FAILED) {
                        x = new JLabel("X  Failed");
                        x.setForeground(Color.RED);
                        panel.add(x);
                        panel.setBackground(new Color(255, 210, 210));
                    }
                    if (matcher != null && matcher.state == ParsingState.END_OF_INPUT) {
                        x = new JLabel("X  EOI");
                        x.setForeground(new Color(255, 128, 0));
                        panel.add(x);
                        panel.setBackground(new Color(255, 230, 200));
                    }
                    for (int i = 0; i < seq.size(); ++i) {
                        Symbol sym = seq.getSymbol(i);
                        JLabel label = new JLabel(sym.toString());
                        Color bg = Color.white;
                        if (i >= newSymbolOffset && i < newSymbolOffset + newSymbolLength) {
                            bg = new Color(180, 255, 180);
                        }
                        label.setBackground(bg);
                        RoundedBorder border = new RoundedBorder(3);
                        if (i == seq.getPos()) {
                            border.setStroke(4);
                            border.setColor(new Color(150, 100, 255));
                        }
                        label.setBorder(border);
                        label.setOpaque(true);
                        panel.add(label);
                    }
                    return panel;
                }
            };
            this.tree.setCellRenderer(renderer);
        }

        public void add(DefaultMutableTreeNode parent, DefaultMutableTreeNode child) {
            parent.insert(child, 0);
            this.treeModel.reload(parent);
        }
    }

    private static class RoundedBorder
    implements Border {
        private final int radius;
        private Color color = null;
        private int stroke = 1;

        RoundedBorder(int radius) {
            this.radius = radius;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public void setStroke(int stroke) {
            this.stroke = stroke;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color prev = g.getColor();
            if (this.color != null) {
                g.setColor(this.color);
            }
            ((Graphics2D)g).setStroke(new BasicStroke(this.stroke));
            g.drawRoundRect(x, y, width - 1, height - 1, this.radius, this.radius);
            g.setColor(prev);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(this.radius, this.radius, this.radius, this.radius);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

