/*
 * Decompiled with CFR 0.152.
 */
package nlScript.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import nlScript.core.DefaultParsedNode;
import nlScript.core.NonTerminal;
import nlScript.core.Symbol;
import nlScript.core.Terminal;

public class Production {
    private final NonTerminal left;
    private final Symbol[] right;
    private AstBuilder astBuilder = null;
    private ExtensionListener extensionListener = null;

    public Production(NonTerminal left, Symbol ... right) {
        this.left = left;
        this.right = Production.removeEpsilon(right);
    }

    private static Symbol[] removeEpsilon(Symbol[] arr) {
        ArrayList<Symbol> list = new ArrayList<Symbol>(Arrays.asList(arr));
        int idx = list.indexOf(Terminal.EPSILON);
        if (idx == -1) {
            return arr;
        }
        list.remove(Terminal.EPSILON);
        return list.toArray(new Symbol[0]);
    }

    public NonTerminal getLeft() {
        return this.left;
    }

    public Symbol[] getRight() {
        return this.right;
    }

    public void setAstBuilder(AstBuilder astBuilder) {
        this.astBuilder = astBuilder;
    }

    public void builtAST(DefaultParsedNode parent, DefaultParsedNode ... children) {
        if (this.astBuilder != null) {
            this.astBuilder.buildAST(parent, children);
            return;
        }
        parent.addChildren(children);
    }

    public void wasExtended(DefaultParsedNode parent, DefaultParsedNode ... children) {
        if (this.extensionListener != null) {
            this.extensionListener.onExtension(parent, children);
        }
    }

    public void onExtension(ExtensionListener listener) {
        if (this.extensionListener != null) {
            throw new RuntimeException("ExtensionListener cannot be overwritten");
        }
        this.extensionListener = listener;
    }

    public String toString() {
        Symbol[] right;
        StringBuilder sb = new StringBuilder();
        String left = this.getLeft().toString();
        for (int k = 0; k < 50 - left.length(); ++k) {
            sb.append(' ');
        }
        sb.append(left);
        sb.append(" -> ");
        for (Symbol symbol : right = this.getRight()) {
            sb.append(symbol).append(" ");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o.getClass() != this.getClass()) {
            return false;
        }
        Production p = (Production)o;
        return this.left.equals(p.left) && Arrays.equals(this.right, p.right);
    }

    public int hashCode() {
        return Objects.hash(this.left, Arrays.hashCode(this.right));
    }

    public static interface AstBuilder {
        public static final AstBuilder DEFAULT = DefaultParsedNode::addChildren;

        public void buildAST(DefaultParsedNode var1, DefaultParsedNode ... var2);
    }

    public static interface ExtensionListener {
        public void onExtension(DefaultParsedNode var1, DefaultParsedNode ... var2);
    }
}

