/*
 * Decompiled with CFR 0.152.
 */
package nlScript.core;

import java.util.ArrayList;
import java.util.HashSet;
import nlScript.core.Generation;
import nlScript.core.Lexer;
import nlScript.core.Matcher;
import nlScript.core.Named;
import nlScript.core.ParsingState;
import nlScript.core.Symbol;
import nlScript.util.RandomInt;

public abstract class Terminal
extends Symbol {
    public static final Terminal EPSILON = new Epsilon();
    public static final Terminal DIGIT = new Digit();
    public static final Terminal LETTER = new Letter();
    public static final Terminal WHITESPACE = new Whitespace();
    public static final Terminal END_OF_INPUT = new EndOfInput();

    public static Terminal literal(String s) {
        return new Literal(s);
    }

    public static Terminal characterClass(String pattern) {
        return new CharacterClass(pattern);
    }

    public Terminal(String symbol) {
        super(symbol);
    }

    @Override
    public boolean isTerminal() {
        return true;
    }

    @Override
    public boolean isNonTerminal() {
        return false;
    }

    @Override
    public boolean isEpsilon() {
        return false;
    }

    public abstract Matcher matches(Lexer var1);

    public abstract Object evaluate(Matcher var1);

    public abstract Generation generate();

    public Named<Terminal> withName(String name) {
        return new Named<Terminal>(this, name);
    }

    public Named<Terminal> withName() {
        return new Named<Terminal>(this);
    }

    public static void main(String[] args) {
        for (int i = 0; i < 120; ++i) {
            Terminal cc = Terminal.characterClass("[A-Za-z0-9]");
            Generation g = cc.generate();
            System.out.println(g.toString());
        }
    }

    public static class Literal
    extends Terminal {
        private String literal;

        private Literal(String literal) {
            super("literal:" + literal);
            this.literal = literal;
        }

        public String getLiteral() {
            return this.literal;
        }

        @Override
        public Matcher matches(Lexer lexer) {
            int pos = lexer.getPosition();
            String symbol = this.literal;
            for (int i = 0; i < symbol.length(); ++i) {
                if (lexer.isAtEnd(i)) {
                    return new Matcher(ParsingState.END_OF_INPUT, pos, lexer.substring(pos, pos + i + 1));
                }
                if (lexer.peek(i) == symbol.charAt(i)) continue;
                return new Matcher(ParsingState.FAILED, pos, lexer.substring(pos, pos + i + 1));
            }
            return new Matcher(ParsingState.SUCCESSFUL, pos, symbol);
        }

        @Override
        public Object evaluate(Matcher matcher) {
            return matcher.parsed;
        }

        @Override
        public String toString() {
            return "'" + this.getSymbol() + "'";
        }

        @Override
        public Generation generate() {
            return new Generation(this.literal, new Generation[0]);
        }
    }

    public static class CharacterClass
    extends Terminal {
        private final Ranges ranges;

        private CharacterClass(String pattern) {
            super(pattern);
            boolean negated;
            StringBuilder b = new StringBuilder(pattern.trim());
            if (b.length() == 0) {
                throw new RuntimeException("empty character class pattern");
            }
            if (b.charAt(0) != '[' || b.charAt(b.length() - 1) != ']') {
                throw new RuntimeException("Wrong character class format: " + pattern);
            }
            int start = 1;
            int end = b.length() - 2;
            boolean bl = negated = b.charAt(1) == '^';
            if (negated) {
                ++start;
            }
            this.ranges = new Ranges(negated);
            if (b.charAt(start) == '-') {
                this.ranges.add(new SingleCharacterRange(45));
                ++start;
            }
            if (b.charAt(end) == '-') {
                this.ranges.add(new SingleCharacterRange(45));
                --end;
            }
            int idx = start;
            while (idx <= end) {
                int nIdx = idx + 1;
                char c = b.charAt(idx);
                if (nIdx <= end && b.charAt(nIdx) == '-') {
                    char u = b.charAt(idx + 2);
                    if (c == '-' || u == '-') {
                        throw new RuntimeException("Wrong character class format: " + pattern);
                    }
                    this.ranges.add(new CharacterRange(c, u));
                    idx += 3;
                    continue;
                }
                this.ranges.add(new SingleCharacterRange(c));
                ++idx;
            }
        }

        @Override
        public Matcher matches(Lexer lexer) {
            int pos = lexer.getPosition();
            if (lexer.isAtEnd()) {
                return new Matcher(ParsingState.END_OF_INPUT, pos, "");
            }
            char c = lexer.peek();
            if (this.ranges.checkCharacter(c)) {
                return new Matcher(ParsingState.SUCCESSFUL, pos, Character.toString(c));
            }
            return new Matcher(ParsingState.FAILED, pos, Character.toString(c));
        }

        @Override
        public Object evaluate(Matcher matcher) {
            return Character.valueOf(matcher.parsed.charAt(0));
        }

        @Override
        public String toString() {
            String ret = super.toString();
            ret = ret.replaceAll("\n", "\\n");
            return ret;
        }

        @Override
        public Generation generate() {
            return this.ranges.generate();
        }
    }

    public static class Epsilon
    extends Terminal {
        private Epsilon() {
            super("epsilon");
        }

        @Override
        public boolean isEpsilon() {
            return true;
        }

        @Override
        public Matcher matches(Lexer lexer) {
            return new Matcher(ParsingState.SUCCESSFUL, lexer.getPosition(), "");
        }

        @Override
        public Object evaluate(Matcher matcher) {
            return null;
        }

        @Override
        public Generation generate() {
            return new Generation("", new Generation[0]);
        }
    }

    public static class Digit
    extends Terminal {
        private Digit() {
            super("digit");
        }

        @Override
        public Matcher matches(Lexer lexer) {
            int pos = lexer.getPosition();
            if (lexer.isAtEnd()) {
                return new Matcher(ParsingState.END_OF_INPUT, pos, "");
            }
            char c = lexer.peek();
            if (Character.isDigit(c)) {
                return new Matcher(ParsingState.SUCCESSFUL, pos, Character.toString(c));
            }
            return new Matcher(ParsingState.FAILED, pos, Character.toString(c));
        }

        @Override
        public Object evaluate(Matcher matcher) {
            return Character.valueOf(matcher.parsed.charAt(0));
        }

        @Override
        public Generation generate() {
            int r = RandomInt.next(0, 9);
            return new Generation(Integer.toString(r), new Generation[0]);
        }
    }

    public static class Letter
    extends Terminal {
        private Letter() {
            super("letter");
        }

        @Override
        public Matcher matches(Lexer lexer) {
            int pos = lexer.getPosition();
            if (lexer.isAtEnd()) {
                return new Matcher(ParsingState.END_OF_INPUT, pos, "");
            }
            char c = lexer.peek();
            if (Character.isLetter(c)) {
                return new Matcher(ParsingState.SUCCESSFUL, pos, Character.toString(c));
            }
            return new Matcher(ParsingState.FAILED, pos, Character.toString(c));
        }

        @Override
        public Object evaluate(Matcher matcher) {
            return Character.valueOf(matcher.parsed.charAt(0));
        }

        @Override
        public Generation generate() {
            int r = RandomInt.next(0, 51);
            r = r <= 25 ? (r += 65) : r - 26 + 97;
            return new Generation(Character.toString((char)r), new Generation[0]);
        }
    }

    public static class Whitespace
    extends Terminal {
        private Whitespace() {
            super("whitespace");
        }

        @Override
        public Matcher matches(Lexer lexer) {
            int pos = lexer.getPosition();
            if (lexer.isAtEnd()) {
                return new Matcher(ParsingState.END_OF_INPUT, pos, "");
            }
            char c = lexer.peek();
            if (c == ' ' || c == '\t') {
                return new Matcher(ParsingState.SUCCESSFUL, pos, Character.toString(c));
            }
            return new Matcher(ParsingState.FAILED, pos, Character.toString(c));
        }

        @Override
        public Object evaluate(Matcher matcher) {
            return Character.valueOf(matcher.parsed.charAt(0));
        }

        @Override
        public Generation generate() {
            return new Generation(" ", new Generation[0]);
        }
    }

    public static class EndOfInput
    extends Terminal {
        private EndOfInput() {
            super("EOI");
        }

        @Override
        public Matcher matches(Lexer lexer) {
            int pos = lexer.getPosition();
            if (lexer.isAtEnd()) {
                return new Matcher(ParsingState.SUCCESSFUL, pos, " ");
            }
            return new Matcher(ParsingState.FAILED, pos, "");
        }

        @Override
        public Object evaluate(Matcher matcher) {
            return null;
        }

        @Override
        public Generation generate() {
            return new Generation("", new Generation[0]);
        }
    }

    private static class Ranges {
        private final ArrayList<CharacterRange> ranges = new ArrayList();
        private final boolean negated;

        public Ranges(boolean negated) {
            this.negated = negated;
        }

        public void add(CharacterRange range) {
            this.ranges.add(range);
        }

        public boolean checkCharacter(int i) {
            for (CharacterRange range : this.ranges) {
                boolean check = range.checkCharacter(i);
                if (!this.negated && check) {
                    return true;
                }
                if (!this.negated || !check) continue;
                return false;
            }
            return this.negated;
        }

        public boolean equals(Object o) {
            if (!o.getClass().equals(this.getClass())) {
                return false;
            }
            HashSet<CharacterRange> ts = new HashSet<CharacterRange>(this.ranges);
            HashSet<CharacterRange> os = new HashSet<CharacterRange>(((Ranges)o).ranges);
            return ts.equals(os);
        }

        public Generation generate() {
            if (this.negated) {
                int r;
                while (!this.checkCharacter(r = RandomInt.next(32, 126))) {
                }
                return new Generation(Character.toString((char)r), new Generation[0]);
            }
            int N = 0;
            for (CharacterRange range : this.ranges) {
                int n = range.upper - range.lower + 1;
                N += n;
            }
            int r = RandomInt.next(0, N - 1);
            for (CharacterRange range : this.ranges) {
                int n = range.upper - range.lower + 1;
                if (r < n) {
                    char ret = (char)(range.lower + r);
                    if (ret == '{' || ret == '[') {
                        System.out.println("Wrong character");
                    }
                    return new Generation(Character.toString(ret), new Generation[0]);
                }
                r -= n;
            }
            throw new RuntimeException("Error generating sample, something went wrong");
        }
    }

    private static class SingleCharacterRange
    extends CharacterRange {
        int number;

        public SingleCharacterRange(int number) {
            super(number, number);
            this.number = number;
        }

        @Override
        public boolean checkCharacter(int i) {
            return i == this.number;
        }
    }

    private static class CharacterRange {
        int lower;
        int upper;

        public CharacterRange(int lower, int upper) {
            this.lower = lower;
            this.upper = upper;
        }

        public boolean checkCharacter(int i) {
            return i >= this.lower && i <= this.upper;
        }

        public boolean equals(Object o) {
            if (!o.getClass().equals(this.getClass())) {
                return false;
            }
            CharacterRange c = (CharacterRange)o;
            return this.lower == c.lower && this.upper == c.upper;
        }
    }
}

