/*
 * Decompiled with CFR 0.152.
 */
package nlScript.ebnf;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import nlScript.Autocompleter;
import nlScript.Evaluator;
import nlScript.core.Autocompletion;
import nlScript.core.Generation;
import nlScript.core.GeneratorHints;
import nlScript.core.Terminal;
import nlScript.ebnf.EBNFCore;
import nlScript.ebnf.Rule;
import nlScript.util.CompletePath;
import nlScript.util.RandomInt;
import nlScript.util.Range;

public class EBNF
extends EBNFCore {
    public static final String DIGIT_NAME = Terminal.DIGIT.getSymbol();
    public static final String LETTER_NAME = Terminal.LETTER.getSymbol();
    public static final String SIGN_NAME = "sign";
    public static final String INTEGER_NAME = "int";
    public static final String FLOAT_NAME = "float";
    public static final String MONTH_NAME = "month";
    public static final String WEEKDAY_NAME = "weekday";
    public static final String WHITESPACE_STAR_NAME = "whitespace-star";
    public static final String WHITESPACE_PLUS_NAME = "whitespace-plus";
    public static final String INTEGER_RANGE_NAME = "integer-range";
    public static final String PATH_NAME = "path";
    public static final String TIME_NAME = "time";
    public static final String DATE_NAME = "date";
    public static final String DATETIME_NAME = "date-time";
    public static final String COLOR_NAME = "color";
    public final Rule SIGN = this.makeSign();
    public final Rule INTEGER = this.makeInteger();
    public final Rule FLOAT = this.makeFloat();
    public final Rule MONTH = this.makeMonth();
    public final Rule WEEKDAY = this.makeWeekday();
    public final Rule WHITESPACE_STAR = this.makeWhitespaceStar();
    public final Rule WHITESPACE_PLUS = this.makeWhitespacePlus();
    public final Rule INTEGER_RANGE = this.makeIntegerRange();
    public final Rule PATH = this.makePath();
    public final Rule TIME = this.makeTime();
    public final Rule DATE = this.makeDate();
    public final Rule DATETIME = this.makeDatetime();
    public final Rule COLOR = this.makeColor();

    public EBNF() {
        this.symbols.put(Terminal.DIGIT.getSymbol(), Terminal.DIGIT);
        this.symbols.put(Terminal.LETTER.getSymbol(), Terminal.LETTER);
    }

    public static void clearFilesystemCache() {
        CompletePath.clearFilesystemCache();
    }

    private Rule makeSign() {
        return this.or(SIGN_NAME, Terminal.literal("-").withName(), Terminal.literal("+").withName());
    }

    private Rule makeInteger() {
        Rule ret = this.sequence(INTEGER_NAME, this.optional(null, this.SIGN.withName(SIGN_NAME)).withName("optional"), this.plus(null, Terminal.DIGIT.withName()).withName("plus"));
        ret.setEvaluator(pn -> Integer.parseInt(pn.getParsedString()));
        ret.setAutocompleter(Autocompleter.DEFAULT_INLINE_AUTOCOMPLETER);
        ret.setGenerator((grammar, hints) -> {
            int min = (Integer)hints.get(GeneratorHints.Key.MIN_VALUE, Integer.MIN_VALUE);
            int max = (Integer)hints.get(GeneratorHints.Key.MAX_VALUE, Integer.MAX_VALUE);
            return new Generation(Integer.toString(RandomInt.next(min, max)), new Generation[0]);
        });
        return ret;
    }

    private Rule makeFloat() {
        Rule ret = this.sequence(FLOAT_NAME, this.optional(null, this.SIGN.withName()).withName(), this.plus(null, Terminal.DIGIT.withName()).withName(), this.optional(null, this.sequence(null, Terminal.literal(".").withName(), this.star(null, Terminal.DIGIT.withName()).withName("star")).withName("sequence")).withName());
        ret.setEvaluator(pn -> Double.parseDouble(pn.getParsedString()));
        ret.setAutocompleter(Autocompleter.DEFAULT_INLINE_AUTOCOMPLETER);
        ret.setGenerator((grammar, hints) -> {
            float min = ((Float)hints.get(GeneratorHints.Key.MIN_VALUE, Float.valueOf(Float.MIN_VALUE))).floatValue();
            float max = ((Float)hints.get(GeneratorHints.Key.MAX_VALUE, Float.valueOf(Float.MAX_VALUE))).floatValue();
            float f = min + (max - min) * (float)Math.random();
            int decimalPlaces = (Integer)hints.get(GeneratorHints.Key.DECIMAL_PLACES, -1);
            String fStr = decimalPlaces == -1 ? Float.toString(f) : this.format(f, decimalPlaces);
            return new Generation(fStr, new Generation[0]);
        });
        return ret;
    }

    private String format(float f, int decimalDigits) {
        StringBuilder sb = new StringBuilder("#");
        if (decimalDigits > 0) {
            sb.append('.');
        }
        for (int i = 0; i < decimalDigits; ++i) {
            sb.append('#');
        }
        DecimalFormat df = new DecimalFormat(sb.toString());
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(dfs);
        df.setGroupingUsed(false);
        return df.format(f);
    }

    private Rule makeWhitespaceStar() {
        Rule ret = this.star(WHITESPACE_STAR_NAME, Terminal.WHITESPACE.withName());
        ret.setAutocompleter((pn, justCheck) -> Autocompletion.literal(pn, pn.getParsedString().isEmpty() ? " " : ""));
        ret.setGenerator((grammar, hints) -> new Generation(" ", new Generation[0]));
        return ret;
    }

    private Rule makeWhitespacePlus() {
        Rule ret = this.plus(WHITESPACE_PLUS_NAME, Terminal.WHITESPACE.withName());
        ret.setAutocompleter((pn, justCheck) -> Autocompletion.literal(pn, pn.getParsedString().isEmpty() ? " " : ""));
        ret.setGenerator((grammar, hints) -> new Generation(" ", new Generation[0]));
        return ret;
    }

    private Rule makeIntegerRange() {
        Rule delimiter = this.sequence(null, this.WHITESPACE_STAR.withName("ws*"), Terminal.literal("-").withName(), this.WHITESPACE_STAR.withName("ws*"));
        Rule ret = this.join(INTEGER_RANGE_NAME, this.INTEGER.withName(), null, null, delimiter.getTarget().withName("delimiter"), "from", "to");
        ret.setEvaluator(pn -> new Range((Integer)pn.evaluate(0), (Integer)pn.evaluate(1)));
        return ret;
    }

    private Rule makeColor() {
        Rule black = this.sequence(null, Terminal.literal("black").withName()).setEvaluator(pn -> EBNF.rgb2int(0, 0, 0));
        Rule white = this.sequence(null, Terminal.literal("white").withName()).setEvaluator(pn -> EBNF.rgb2int(255, 255, 255));
        Rule red = this.sequence(null, Terminal.literal("red").withName()).setEvaluator(pn -> EBNF.rgb2int(255, 0, 0));
        Rule orange = this.sequence(null, Terminal.literal("orange").withName()).setEvaluator(pn -> EBNF.rgb2int(255, 128, 0));
        Rule yellow = this.sequence(null, Terminal.literal("yellow").withName()).setEvaluator(pn -> EBNF.rgb2int(255, 255, 0));
        Rule lawngreen = this.sequence(null, Terminal.literal("lawn green").withName()).setEvaluator(pn -> EBNF.rgb2int(128, 255, 0));
        Rule green = this.sequence(null, Terminal.literal("green").withName()).setEvaluator(pn -> EBNF.rgb2int(0, 255, 0));
        Rule springgreen = this.sequence(null, Terminal.literal("spring green").withName()).setEvaluator(pn -> EBNF.rgb2int(0, 255, 180));
        Rule cyan = this.sequence(null, Terminal.literal("cyan").withName()).setEvaluator(pn -> EBNF.rgb2int(0, 255, 255));
        Rule azure = this.sequence(null, Terminal.literal("azure").withName()).setEvaluator(pn -> EBNF.rgb2int(0, 128, 255));
        Rule blue = this.sequence(null, Terminal.literal("blue").withName()).setEvaluator(pn -> EBNF.rgb2int(0, 0, 255));
        Rule violet = this.sequence(null, Terminal.literal("violet").withName()).setEvaluator(pn -> EBNF.rgb2int(128, 0, 255));
        Rule magenta = this.sequence(null, Terminal.literal("magenta").withName()).setEvaluator(pn -> EBNF.rgb2int(255, 0, 255));
        Rule pink = this.sequence(null, Terminal.literal("pink").withName()).setEvaluator(pn -> EBNF.rgb2int(255, 0, 128));
        Rule gray = this.sequence(null, Terminal.literal("gray").withName()).setEvaluator(pn -> EBNF.rgb2int(128, 128, 128));
        Rule custom = this.tuple(null, this.INTEGER.withName(), "red", "green", "blue");
        custom.setEvaluator(pn -> {
            int r = (Integer)pn.evaluate("red");
            int g = (Integer)pn.evaluate("green");
            int b = (Integer)pn.evaluate("blue");
            return EBNF.rgb2int(r, g, b);
        });
        custom.setGenerator((grammar, hints) -> {
            int r = RandomInt.next(0, 255);
            int g = RandomInt.next(0, 255);
            int b = RandomInt.next(0, 255);
            return new Generation("(" + r + ", " + g + ", " + b + ")", new Generation[0]);
        });
        return this.or(COLOR_NAME, custom.withName(), black.withName(), white.withName(), red.withName(), orange.withName(), yellow.withName(), lawngreen.withName(), green.withName(), springgreen.withName(), cyan.withName(), azure.withName(), blue.withName(), violet.withName(), magenta.withName(), pink.withName(), gray.withName());
    }

    private static int rgb2int(int r, int g, int b) {
        return 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    private Rule makeTime() {
        Rule hour = this.sequence(null, this.optional(null, Terminal.DIGIT.withName()).withName(), Terminal.DIGIT.withName());
        hour.setAutocompleter(Autocompleter.DEFAULT_INLINE_AUTOCOMPLETER);
        Rule minute = this.sequence(null, Terminal.DIGIT.withName(), Terminal.DIGIT.withName());
        minute.setAutocompleter(Autocompleter.DEFAULT_INLINE_AUTOCOMPLETER);
        Rule ret = this.sequence(TIME_NAME, hour.withName("HH"), Terminal.literal(":").withName(), minute.withName("MM"));
        ret.setGenerator((grammar, hints) -> {
            Random random = new Random();
            int h = random.nextInt(24);
            int m = random.nextInt(60);
            String mm = Integer.toString(m);
            if (m < 10) {
                mm = "0" + mm;
            }
            return new Generation(h + ":" + mm, new Generation[0]);
        });
        ret.setEvaluator(pn -> LocalTime.parse(pn.getParsedString(), DateTimeFormatter.ofPattern("H:mm")));
        ret.setAutocompleter(new Autocompleter.EntireSequenceCompleter(this, new HashMap<String, ArrayList<Autocompletion>>()));
        return ret;
    }

    private Rule makeMonth() {
        return this.or(MONTH_NAME, this.sequence(null, Terminal.literal("January").withName()).setEvaluator(pn -> 0).withName("january"), this.sequence(null, Terminal.literal("February").withName()).setEvaluator(pn -> 1).withName("february"), this.sequence(null, Terminal.literal("March").withName()).setEvaluator(pn -> 2).withName("march"), this.sequence(null, Terminal.literal("April").withName()).setEvaluator(pn -> 3).withName("april"), this.sequence(null, Terminal.literal("May").withName()).setEvaluator(pn -> 4).withName("may"), this.sequence(null, Terminal.literal("June").withName()).setEvaluator(pn -> 5).withName("june"), this.sequence(null, Terminal.literal("July").withName()).setEvaluator(pn -> 6).withName("july"), this.sequence(null, Terminal.literal("August").withName()).setEvaluator(pn -> 7).withName("august"), this.sequence(null, Terminal.literal("September").withName()).setEvaluator(pn -> 8).withName("september"), this.sequence(null, Terminal.literal("October").withName()).setEvaluator(pn -> 9).withName("october"), this.sequence(null, Terminal.literal("November").withName()).setEvaluator(pn -> 10).withName("november"), this.sequence(null, Terminal.literal("December").withName()).setEvaluator(pn -> 11).withName("december"));
    }

    private Rule makeWeekday() {
        return this.or(WEEKDAY_NAME, this.sequence(null, Terminal.literal("Monday").withName()).setEvaluator(pn -> 0).withName("monday"), this.sequence(null, Terminal.literal("Tuesday").withName()).setEvaluator(pn -> 1).withName("tuesday"), this.sequence(null, Terminal.literal("Wednesday").withName()).setEvaluator(pn -> 2).withName("wednesday"), this.sequence(null, Terminal.literal("Thursday").withName()).setEvaluator(pn -> 3).withName("thursday"), this.sequence(null, Terminal.literal("Friday").withName()).setEvaluator(pn -> 4).withName("friday"), this.sequence(null, Terminal.literal("Saturday").withName()).setEvaluator(pn -> 5).withName("saturday"), this.sequence(null, Terminal.literal("Sunday").withName()).setEvaluator(pn -> 6).withName("sunday"));
    }

    private Rule makeDate() {
        Rule day = this.sequence(null, this.optional(null, Terminal.DIGIT.withName()).withName(), Terminal.DIGIT.withName());
        day.setAutocompleter(Autocompleter.DEFAULT_INLINE_AUTOCOMPLETER);
        Rule year = this.sequence(null, Terminal.DIGIT.withName(), Terminal.DIGIT.withName(), Terminal.DIGIT.withName(), Terminal.DIGIT.withName());
        year.setAutocompleter(Autocompleter.DEFAULT_INLINE_AUTOCOMPLETER);
        Rule ret = this.sequence(DATE_NAME, day.withName("day"), Terminal.literal(" ").withName(), this.MONTH.withName(MONTH_NAME), Terminal.literal(" ").withName(), year.withName("year"));
        ret.setEvaluator(pn -> LocalDate.parse(pn.getParsedString(), DateTimeFormatter.ofPattern("d MMMM yyyy")));
        ret.setAutocompleter(new Autocompleter.EntireSequenceCompleter(this, new HashMap<String, ArrayList<Autocompletion>>()));
        return ret;
    }

    private Rule makeDatetime() {
        Rule ret = this.sequence(DATETIME_NAME, this.DATE.withName(DATE_NAME), Terminal.literal(" ").withName(), this.TIME.withName(TIME_NAME));
        ret.setEvaluator(pn -> {
            LocalDate date = (LocalDate)pn.evaluate(DATE_NAME);
            LocalTime time = (LocalTime)pn.evaluate(TIME_NAME);
            return LocalDateTime.of(date, time);
        });
        ret.setAutocompleter(new Autocompleter.EntireSequenceCompleter(this, new HashMap<String, ArrayList<Autocompletion>>()));
        return ret;
    }

    private Rule makePath() {
        Rule innerPath = this.plus(null, Terminal.characterClass("[^'<>|?*\n]").withName("inner-path"));
        innerPath.setEvaluator(Evaluator.DEFAULT_EVALUATOR);
        innerPath.setAutocompleter(Autocompleter.PATH_AUTOCOMPLETER);
        Rule path = this.sequence(PATH_NAME, Terminal.literal("'").withName(), innerPath.withName(PATH_NAME), Terminal.literal("'").withName());
        path.setEvaluator(pn -> pn.evaluate(PATH_NAME));
        path.setAutocompleter(new Autocompleter.EntireSequenceCompleter(this, new HashMap<String, ArrayList<Autocompletion>>()));
        return path;
    }
}

