/*
 * Decompiled with CFR 0.152.
 */
package nlScript.ebnf;

import java.util.ArrayList;
import nlScript.Evaluator;
import nlScript.ParsedNode;
import nlScript.core.BNF;
import nlScript.core.DefaultParsedNode;
import nlScript.core.Generation;
import nlScript.core.Generator;
import nlScript.core.GeneratorHints;
import nlScript.core.Named;
import nlScript.core.NonTerminal;
import nlScript.core.Production;
import nlScript.core.Symbol;
import nlScript.core.Terminal;
import nlScript.ebnf.EBNFProduction;
import nlScript.ebnf.Repeat;
import nlScript.ebnf.Rule;
import nlScript.ebnf.Star;
import nlScript.util.RandomInt;
import nlScript.util.Range;

public class Join
extends Rule {
    private final Named<?> open;
    private final Named<?> close;
    private final Named<?> delimiter;
    private Range cardinality;
    private boolean onlyKeepEntries = true;
    private final Generator DEFAULT_GENERATOR = (grammar, hints) -> {
        Generation gen;
        GeneratorHints cHints;
        boolean hasOpen = this.getOpen() != null && !this.getOpen().getSymbol().isEpsilon();
        boolean hasClose = this.getClose() != null && !this.getClose().getSymbol().isEpsilon();
        boolean hasDelimiter = this.getDelimiter() != null && !this.getDelimiter().getSymbol().isEpsilon();
        int lower = this.getCardinality().getLower();
        int upper = this.getCardinality().getUpper();
        if (upper == Integer.MAX_VALUE) {
            upper = (Integer)hints.get(GeneratorHints.Key.MAX_NUMBER, upper);
        }
        int n = RandomInt.next(lower, upper);
        StringBuilder generatedString = new StringBuilder();
        ArrayList<Generation> generations = new ArrayList<Generation>();
        if (hasOpen) {
            Generator generator = this.getChildGenerator(this.getOpen().getName(), grammar, this.getOpen().getSymbol());
            cHints = this.getChildGeneratorHints(this.getOpen().getName());
            gen = generator.generate(grammar, cHints);
            gen.setName(this.getOpen().getName());
            generatedString.append(gen);
            generations.add(gen);
        }
        for (int i = 0; i < n; ++i) {
            String name = this.getParsedNameForChild(i);
            Generator generator = this.getChildGenerator(name, grammar, this.getEntry().getSymbol());
            GeneratorHints cHints2 = this.getChildGeneratorHints(name);
            Generation gen2 = generator.generate(grammar, cHints2);
            gen2.setName(name);
            generatedString.append(gen2);
            generations.add(gen2);
            if (!hasDelimiter || i >= n - 1) continue;
            generator = this.getChildGenerator(this.getDelimiter().getName(), grammar, this.getDelimiter().getSymbol());
            cHints2 = this.getChildGeneratorHints(this.getDelimiter().getName());
            gen2 = generator.generate(grammar, cHints2);
            gen2.setName(this.getDelimiter().getName());
            generatedString.append(gen2);
            generations.add(gen2);
        }
        if (hasClose) {
            Generator generator = this.getChildGenerator(this.getClose().getName(), grammar, this.getClose().getSymbol());
            cHints = this.getChildGeneratorHints(this.getClose().getName());
            gen = generator.generate(grammar, cHints);
            gen.setName(this.getClose().getName());
            generatedString.append(gen);
            generations.add(gen);
        }
        return new Generation(generatedString.toString(), generations.toArray(generations.toArray(new Generation[0])));
    };

    private static Named<?>[] makeChildren(Named<?> entry, Named<?> open, Named<?> close, Named<?> delimiter) {
        int n = 1;
        if (open != null) {
            ++n;
        }
        if (close != null) {
            ++n;
        }
        if (delimiter != null) {
            ++n;
        }
        Named[] ret = new Named[n];
        int i = 0;
        ret[i++] = entry;
        if (open != null) {
            ret[i++] = open;
        }
        if (close != null) {
            ret[i++] = close;
        }
        if (delimiter != null) {
            ret[i] = delimiter;
        }
        return ret;
    }

    public Join(NonTerminal tgt, Named<?> entry, Named<?> open, Named<?> close, Named<?> delimiter, Range cardinality) {
        super("join", tgt, Join.makeChildren(entry, open, close, delimiter));
        this.open = open;
        this.close = close;
        this.delimiter = delimiter;
        this.cardinality = cardinality;
        this.setEvaluator(Evaluator.ALL_CHILDREN_EVALUATOR);
    }

    public Named<?> getOpen() {
        return this.open;
    }

    public Named<?> getClose() {
        return this.close;
    }

    public Named<?> getDelimiter() {
        return this.delimiter;
    }

    public Named<?> getEntry() {
        return this.children[0];
    }

    public Range getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(Range cardinality) {
        this.cardinality = cardinality;
    }

    public void setOnlyKeepEntries(boolean onlyKeepEntries) {
        this.onlyKeepEntries = onlyKeepEntries;
    }

    @Override
    public void createBNF(BNF g) {
        EBNFProduction p;
        boolean hasDelimiter;
        Symbol first = this.children[0].getSymbol();
        Named<NonTerminal> next = new NonTerminal("next-" + NonTerminal.makeRandomSymbol()).withName("next");
        boolean hasOpen = this.open != null && !this.open.getSymbol().isEpsilon();
        boolean hasClose = this.close != null && !this.close.getSymbol().isEpsilon();
        boolean bl = hasDelimiter = this.delimiter != null && !this.delimiter.getSymbol().isEpsilon();
        if (hasDelimiter) {
            p = Join.addProduction(g, this, next.get(), this.delimiter.getSymbol(), first);
            p.onExtension((parent, children) -> {
                int nthEntry = ((ParsedNode)parent).getNthEntryInParent() + 1;
                children[0].setName("delimiter");
                children[1].setName(this.getParsedNameForChild(nthEntry));
            });
            if (this.onlyKeepEntries) {
                p.setAstBuilder((parent, children) -> parent.addChildren(children[1]));
            } else {
                p.setAstBuilder(Production.AstBuilder.DEFAULT);
            }
        } else {
            p = Join.addProduction(g, this, next.get(), first);
            p.onExtension((parent, children) -> {
                int nthEntry = ((ParsedNode)parent).getNthEntryInParent() + 1;
                children[0].setName(this.getParsedNameForChild(nthEntry));
            });
            p.setAstBuilder((parent, children) -> parent.addChildren(children[0]));
        }
        Production.AstBuilder astBuilder = (parent, children) -> {
            parent.addChildren(children[0]);
            for (DefaultParsedNode pn : children[1].getChildren()) {
                parent.addChildren(pn.getChildren());
            }
        };
        NonTerminal repetition = new NonTerminal("repetition:" + NonTerminal.makeRandomSymbol());
        if (this.cardinality.equals(Range.PLUS)) {
            Star star = new Star(null, next);
            star.createBNF(g);
            this.productions.addAll(star.productions);
            EBNFProduction p2 = Join.addProduction(g, this, repetition, first, star.tgt);
            p2.onExtension((parent, children) -> {
                children[0].setName(this.getParsedNameForChild(0));
                children[1].setName("star");
            });
            p2.setAstBuilder(astBuilder);
        } else if (this.cardinality.equals(Range.STAR)) {
            Star star = new Star(null, next);
            star.createBNF(g);
            this.productions.addAll(star.productions);
            EBNFProduction p1 = Join.addProduction(g, this, repetition, first, star.tgt);
            EBNFProduction p2 = Join.addProduction(g, this, repetition, Terminal.EPSILON);
            p1.setAstBuilder(astBuilder);
            p2.setAstBuilder((parent, children) -> {});
            p1.onExtension((parent, children) -> {
                children[0].setName(this.getParsedNameForChild(0));
                children[1].setName("star");
            });
        } else if (this.cardinality.equals(Range.OPTIONAL)) {
            EBNFProduction p1 = Join.addProduction(g, this, repetition, first);
            p1.onExtension((parent, children) -> children[0].setName(this.getParsedNameForChild(0)));
            EBNFProduction p2 = Join.addProduction(g, this, repetition, Terminal.EPSILON);
            p2.setAstBuilder((parent, children) -> {});
        } else {
            int lower = this.cardinality.getLower();
            int upper = this.cardinality.getUpper();
            if (lower == 0 && upper == 0) {
                Join.addProduction(g, this, repetition, Terminal.EPSILON).setAstBuilder((parent, children) -> {});
            } else if (lower == 1 && upper == 1) {
                EBNFProduction p3 = Join.addProduction(g, this, repetition, first);
                p3.onExtension((parent, children) -> children[0].setName(this.getParsedNameForChild(0)));
            } else if (lower <= 0) {
                Repeat repeat = new Repeat(null, next, 0, upper - 1);
                repeat.createBNF(g);
                this.productions.addAll(repeat.productions);
                EBNFProduction p4 = Join.addProduction(g, this, repetition, first, repeat.tgt);
                p4.setAstBuilder(astBuilder);
                p4.onExtension((parent, children) -> {
                    children[0].setName(this.getParsedNameForChild(0));
                    children[1].setName("repeat");
                });
                Join.addProduction(g, this, repetition, Terminal.EPSILON).setAstBuilder((parent, children) -> {});
            } else {
                Repeat repeat = new Repeat(null, next, lower - 1, upper - 1);
                repeat.createBNF(g);
                this.productions.addAll(repeat.productions);
                EBNFProduction p5 = Join.addProduction(g, this, repetition, first, repeat.tgt);
                p5.setAstBuilder(astBuilder);
                p5.onExtension((parent, children) -> {
                    children[0].setName(this.getParsedNameForChild(0));
                    children[1].setName("repeat");
                });
            }
        }
        if (!hasOpen && !hasClose) {
            EBNFProduction p6 = Join.addProduction(g, this, this.tgt, repetition);
            p6.onExtension((parent, children) -> children[0].setName("repetition"));
            p6.setAstBuilder((parent, children) -> parent.addChildren(children[0].getChildren()));
        } else {
            EBNFProduction p7 = Join.addProduction(g, this, this.tgt, this.open.getSymbol(), repetition, this.close.getSymbol());
            p7.onExtension((parent, children) -> {
                if (!this.onlyKeepEntries) {
                    children[0].setName("open");
                }
                children[1].setName("repetition");
                if (!this.onlyKeepEntries) {
                    children[2].setName("close");
                }
            });
            p7.setAstBuilder((parent, children) -> {
                if (!this.onlyKeepEntries) {
                    parent.addChildren(children[0]);
                }
                parent.addChildren(children[1].getChildren());
                if (!this.onlyKeepEntries) {
                    parent.addChildren(children[2]);
                }
            });
        }
    }

    @Override
    public Generator getDefaultGenerator() {
        return this.DEFAULT_GENERATOR;
    }
}

