/*
 * Decompiled with CFR 0.152.
 */
package nlScript.ebnf;

import nlScript.Evaluator;
import nlScript.ParsedNode;
import nlScript.core.BNF;
import nlScript.core.Generation;
import nlScript.core.Generator;
import nlScript.core.GeneratorHints;
import nlScript.core.Named;
import nlScript.core.NonTerminal;
import nlScript.core.Production;
import nlScript.core.Symbol;
import nlScript.ebnf.EBNFProduction;
import nlScript.ebnf.Rule;
import nlScript.util.RandomInt;

public class Repeat
extends Rule {
    private final int from;
    private final int to;
    private final Generator DEFAULT_GENERATOR = (grammar, hints) -> {
        int nMin = (Integer)hints.get(GeneratorHints.Key.MIN_NUMBER, this.getFrom());
        int nMax = (Integer)hints.get(GeneratorHints.Key.MAX_NUMBER, this.getTo());
        int n = RandomInt.next(nMin, nMax);
        StringBuilder generatedString = new StringBuilder();
        Generation[] generations = new Generation[n];
        for (int i = 0; i < n; ++i) {
            String name = this.getParsedNameForChild(i);
            Generator generator = this.getChildGenerator(name, grammar, this.getEntry().getSymbol());
            GeneratorHints cHints = this.getChildGeneratorHints(name);
            Generation gen = generator.generate(grammar, cHints);
            gen.setName(name);
            generatedString.append(gen);
            generations[i] = gen;
        }
        return new Generation(generatedString.toString(), generations);
    };

    public Repeat(NonTerminal tgt, Named<?> child, int from, int to) {
        super("repeat", tgt, child);
        this.from = from;
        this.to = to;
        this.setEvaluator(Evaluator.ALL_CHILDREN_EVALUATOR);
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public Named<?> getEntry() {
        return this.children[0];
    }

    @Override
    public void createBNF(BNF g) {
        for (int seqLen = this.to; seqLen >= this.from; --seqLen) {
            Symbol[] rhs = new Symbol[seqLen];
            for (int i = 0; i < seqLen; ++i) {
                rhs[i] = this.children[0].getSymbol();
            }
            EBNFProduction p = Repeat.addProduction(g, this, this.tgt, rhs);
            p.onExtension((parent, children) -> {
                for (int c = 0; c < children.length; ++c) {
                    ParsedNode ch = (ParsedNode)children[c];
                    ch.setNthEntryInParent(c);
                    ch.setName(this.getParsedNameForChild(c));
                }
            });
            p.setAstBuilder(Production.AstBuilder.DEFAULT);
        }
    }

    @Override
    public Generator getDefaultGenerator() {
        return this.DEFAULT_GENERATOR;
    }
}

