/*
 * Decompiled with CFR 0.152.
 */
package nlScript.ebnf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import nlScript.Autocompleter;
import nlScript.Evaluator;
import nlScript.core.BNF;
import nlScript.core.Generatable;
import nlScript.core.Generation;
import nlScript.core.Generator;
import nlScript.core.GeneratorHints;
import nlScript.core.Named;
import nlScript.core.NonTerminal;
import nlScript.core.RepresentsSymbol;
import nlScript.core.Symbol;
import nlScript.core.Terminal;
import nlScript.ebnf.EBNFCore;
import nlScript.ebnf.EBNFProduction;
import nlScript.ebnf.NamedRule;
import nlScript.ebnf.ParseListener;

public abstract class Rule
implements RepresentsSymbol,
Generatable {
    protected final String type;
    protected final NonTerminal tgt;
    protected final Named<?>[] children;
    protected String[] parsedChildNames;
    private Evaluator evaluator;
    private Autocompleter autocompleter;
    private ParseListener onSuccessfulParsed;
    protected final ArrayList<EBNFProduction> productions = new ArrayList();
    private Generator generator;
    private HashMap<String, Generator> childGenerators;
    private GeneratorHints generatorHints;
    private HashMap<String, GeneratorHints> childGeneratorHints;

    public Rule(String type, NonTerminal tgt, Named<?> ... children) {
        this.type = type;
        if (tgt != null) {
            this.tgt = tgt;
        } else {
            String t = type;
            if (children.length == 1) {
                t = t + "(" + children[0].getSymbol() + ")";
            }
            t = t + ":" + NonTerminal.makeRandomSymbol();
            this.tgt = new NonTerminal(t);
        }
        this.children = children;
    }

    public NamedRule withName(String name) {
        return new NamedRule(this, name);
    }

    public NamedRule withName() {
        return new NamedRule(this);
    }

    public NonTerminal getTarget() {
        return this.tgt;
    }

    @Override
    public Symbol getRepresentedSymbol() {
        return this.tgt;
    }

    public Named<?>[] getChildren() {
        return this.children;
    }

    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    public Rule setEvaluator(Evaluator evaluator) {
        this.evaluator = evaluator;
        return this;
    }

    public Autocompleter getAutocompleter() {
        return this.autocompleter;
    }

    public Rule setAutocompleter(Autocompleter autocompleter) {
        this.autocompleter = autocompleter;
        return this;
    }

    public int getChildIndexForName(String name) {
        for (int i = 0; i < this.children.length; ++i) {
            if (!this.children[i].getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public Rule onSuccessfulParsed(ParseListener listener) {
        this.onSuccessfulParsed = listener;
        return this;
    }

    public ParseListener getOnSuccessfulParsed() {
        return this.onSuccessfulParsed;
    }

    public static EBNFProduction addProduction(BNF grammar, Rule rule, NonTerminal left, Symbol ... right) {
        EBNFProduction production = new EBNFProduction(rule, left, right);
        rule.productions.add(production);
        grammar.addProduction(production);
        return production;
    }

    public String getParsedNameForChild(int idx) {
        if (this.parsedChildNames != null) {
            if (this.parsedChildNames.length == 1) {
                return this.parsedChildNames[0];
            }
            if (idx >= this.parsedChildNames.length) {
                return "no name";
            }
            return this.parsedChildNames[idx];
        }
        if (this.children.length == 1) {
            return this.children[0].getName();
        }
        if (idx < this.children.length) {
            return this.children[idx].getName();
        }
        return "no name";
    }

    protected static Symbol[] getSymbols(Named<?> ... named) {
        Symbol[] ret = new Symbol[named.length];
        for (int i = 0; i < named.length; ++i) {
            ret[i] = named[i].getSymbol();
        }
        return ret;
    }

    public void setParsedChildNames(String ... parsedChildNames) {
        this.parsedChildNames = parsedChildNames;
    }

    public abstract void createBNF(BNF var1);

    @Override
    public Generation generate(EBNFCore grammar) {
        return this.getGenerator().generate(grammar, this.getGeneratorHints());
    }

    public void setGenerator(Generator generator) {
        this.generator = generator;
    }

    public void setGeneratorHints(GeneratorHints hints) {
        this.generatorHints = hints;
    }

    public Generator getGenerator() {
        return this.generator != null ? this.generator : this.getDefaultGenerator();
    }

    public GeneratorHints getGeneratorHints() {
        if (this.generatorHints == null) {
            this.generatorHints = new GeneratorHints();
        }
        return this.generatorHints;
    }

    public abstract Generator getDefaultGenerator();

    public void setChildGeneratorHints(String childName, GeneratorHints hints) {
        if (this.childGeneratorHints == null) {
            this.childGeneratorHints = new HashMap();
        }
        this.childGeneratorHints.put(childName, hints);
    }

    public boolean hasParsedName(String name) {
        if (this.parsedChildNames == null) {
            for (Named<?> n : this.children) {
                if (!n.getName().equals(name)) continue;
                return true;
            }
            return false;
        }
        for (String parsedName : this.parsedChildNames) {
            if (!parsedName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public Generator getChildGenerator(String childName, EBNFCore ebnf, Symbol otherwise) {
        if (this.childGenerators == null || this.childGenerators.get(childName) == null) {
            if (otherwise instanceof Terminal) {
                return (grammar, hints) -> ((Terminal)otherwise).generate();
            }
            if (otherwise instanceof NonTerminal) {
                ArrayList<Rule> rules = ebnf.getRules((NonTerminal)otherwise);
                Rule randomRule = rules.get(new Random().nextInt(rules.size()));
                return randomRule.getGenerator();
            }
            throw new RuntimeException("Don't know how to create a Generator for " + otherwise);
        }
        return this.childGenerators.get(childName);
    }

    public GeneratorHints getChildGeneratorHints(String childName) {
        GeneratorHints ret;
        GeneratorHints generatorHints = ret = this.childGeneratorHints != null ? this.childGeneratorHints.get(childName) : null;
        if (ret == null) {
            ret = new GeneratorHints();
        }
        return ret;
    }
}

