/*
 * Decompiled with CFR 0.152.
 */
package nlScript.ui;

import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import nlScript.core.Autocompletion;
import nlScript.ebnf.Rule;
import nlScript.ui.HighlightPainter;

public class ParameterizedCompletionContext
implements KeyListener {
    private final JTextComponent tc;
    private final ArrayList<ParameterChangeListener> parameterChangeListeners = new ArrayList();
    public final HighlightPainter highlightPainter = new HighlightPainter.Outline(Color.GRAY);
    public final HighlightPainter cursorHighlightPainter = new HighlightPainter.Outline(new Color(46080));
    private final ArrayList<Param> parameters = new ArrayList();
    private Autocompletion forAutocompletion = null;

    public void addParameterChangeListener(ParameterChangeListener l) {
        this.parameterChangeListeners.add(l);
    }

    public void removeParameterChangeListener(ParameterChangeListener l) {
        this.parameterChangeListeners.remove(l);
    }

    private void fireParameterChanged(int i, boolean wasLast) {
        ArrayList<ParameterChangeListener> copy = new ArrayList<ParameterChangeListener>(this.parameterChangeListeners);
        for (ParameterChangeListener l : copy) {
            l.parameterChanged(this, i, wasLast);
        }
    }

    public ParameterizedCompletionContext(JTextComponent tc) {
        this.tc = tc;
    }

    private Param addHighlight(String name, Autocompletion.Parameterized autocompletion, List<Autocompletion> allOptions, int i0, int i1) {
        return this.addHighlight(name, autocompletion, allOptions, i0, i1, this.highlightPainter);
    }

    private Param addHighlight(String name, Autocompletion.Parameterized autocompletion, List<Autocompletion> allOptions, int i0, int i1, Highlighter.HighlightPainter highlightPainter) {
        try {
            int start = i0 == 0 ? 0 : i0 - 1;
            Object tag = this.tc.getHighlighter().addHighlight(start, i1, highlightPainter);
            Highlighter.Highlight hl = this.findHighlight(start, i1);
            return new Param(name, autocompletion, allOptions, hl, tag);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Highlighter.Highlight findHighlight(int offs0, int offs1) {
        Highlighter.Highlight[] highlights;
        for (Highlighter.Highlight hl : highlights = this.tc.getHighlighter().getHighlights()) {
            if (hl.getStartOffset() != offs0 || hl.getEndOffset() != offs1) continue;
            return hl;
        }
        return null;
    }

    private int getParamIndexForCursorPosition(int pos) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            Param p = this.parameters.get(i);
            Highlighter.Highlight highlight = p.highlight;
            if (pos < highlight.getStartOffset() + 1 || pos > highlight.getEndOffset()) continue;
            return i;
        }
        return -1;
    }

    public int getCurrentParamIndex() {
        return this.getParamIndexForCursorPosition(this.tc.getCaretPosition());
    }

    public Param getParameter(int idx) {
        return this.parameters.get(idx);
    }

    public Param getCurrentParameter() {
        return this.parameters.get(this.getCurrentParamIndex());
    }

    private int getNextParamIndexForCursorPosition(int pos) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            Param p = this.parameters.get(i);
            Highlighter.Highlight highlight = p.highlight;
            if (pos >= highlight.getStartOffset() + 1) continue;
            return i;
        }
        return -1;
    }

    private int getPreviousParamIndexForCursorPosition(int pos) {
        for (int i = this.parameters.size() - 1; i >= 0; --i) {
            Param p = this.parameters.get(i);
            Highlighter.Highlight highlight = p.highlight;
            if (pos <= highlight.getEndOffset()) continue;
            return i;
        }
        return -1;
    }

    public Autocompletion getForAutocompletion() {
        return this.forAutocompletion;
    }

    public void replaceSelection(Autocompletion autocompletion) {
        this.forAutocompletion = autocompletion;
        int offset = this.tc.getSelectionStart();
        ArrayList<ParsedParam> parsedParams = new ArrayList<ParsedParam>();
        String insertionString = ParameterizedCompletionContext.parseParameters(autocompletion, parsedParams);
        this.tc.replaceSelection(insertionString);
        this.parameters.clear();
        for (ParsedParam pp : parsedParams) {
            this.parameters.add(this.addHighlight(pp.name, pp.parameterizedCompletion, pp.allOptions, offset + pp.i0, offset + pp.i1));
        }
        int cursor = offset + insertionString.length();
        this.parameters.add(this.addHighlight("", null, null, cursor, cursor, this.cursorHighlightPainter));
        this.cycle(0);
        this.tc.addKeyListener(this);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.isConsumed()) {
            return;
        }
        int kc = e.getKeyCode();
        if (kc == 9) {
            if (e.isShiftDown()) {
                this.previous();
            } else {
                this.next();
            }
            e.consume();
        } else if (kc == 10) {
            this.next();
            e.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public int getParametersSize() {
        return this.parameters.size();
    }

    public void cycle(int currentParameterIndex) {
        boolean last;
        int nParameters = this.parameters.size();
        if (nParameters == 0) {
            return;
        }
        if (currentParameterIndex == -1) {
            for (Param param : this.parameters) {
                this.tc.getHighlighter().removeHighlight(param.highlightTag);
            }
            this.tc.removeKeyListener(this);
            this.fireParameterChanged(-1, false);
            this.parameterChangeListeners.clear();
            return;
        }
        Highlighter.Highlight hl = this.parameters.get(currentParameterIndex).highlight;
        boolean bl = last = currentParameterIndex == nParameters - 1;
        if (!last) {
            this.tc.setCaretPosition(hl.getEndOffset());
            this.tc.moveCaretPosition(hl.getStartOffset() + 1);
            this.fireParameterChanged(currentParameterIndex, false);
        } else {
            this.finish(true);
        }
    }

    public void next() {
        int caret = this.tc.getCaretPosition();
        int idx = this.getNextParamIndexForCursorPosition(caret);
        this.cycle(idx);
    }

    public void previous() {
        int caret = this.tc.getCaretPosition();
        int idx = this.getPreviousParamIndexForCursorPosition(caret);
        this.cycle(idx);
    }

    public void finish(boolean moveCaret) {
        if (moveCaret) {
            Highlighter.Highlight hl = this.parameters.get(this.parameters.size() - 1).highlight;
            this.tc.setCaretPosition(hl.getEndOffset());
        }
        for (Param param : this.parameters) {
            this.tc.getHighlighter().removeHighlight(param.highlightTag);
        }
        this.tc.removeKeyListener(this);
        this.fireParameterChanged(this.parameters.size() - 1, true);
        this.parameterChangeListeners.clear();
    }

    public void cancel() {
        for (Param param : this.parameters) {
            this.tc.getHighlighter().removeHighlight(param.highlightTag);
        }
        this.tc.removeKeyListener(this);
        this.parameterChangeListeners.clear();
    }

    public static String parseParameters(Autocompletion autocompletion, List<ParsedParam> ret) {
        if (autocompletion instanceof Autocompletion.Literal) {
            return ParameterizedCompletionContext.parseParameters((Autocompletion.Literal)autocompletion, ret);
        }
        if (autocompletion instanceof Autocompletion.Parameterized) {
            return ParameterizedCompletionContext.parseParameters((Autocompletion.Parameterized)autocompletion, ret);
        }
        if (autocompletion instanceof Autocompletion.EntireSequence) {
            return ParameterizedCompletionContext.parseParameters((Autocompletion.EntireSequence)autocompletion, ret, 0);
        }
        throw new RuntimeException("Unexpected autocompletion type: " + autocompletion.getClass());
    }

    public static String parseParameters(Autocompletion.Literal autocompletion, List<ParsedParam> ret) {
        return autocompletion.getCompletion(Autocompletion.Purpose.FOR_INSERTION);
    }

    public static String parseParameters(Autocompletion.Parameterized autocompletion, List<ParsedParam> ret) {
        String s = autocompletion.paramName;
        List<Autocompletion> allOptions = Collections.singletonList(autocompletion);
        ret.add(new ParsedParam(s, 0, s.length(), autocompletion, allOptions));
        return s;
    }

    public static String parseParameters(Autocompletion.EntireSequence autocompletion, List<ParsedParam> ret, int offset) {
        List<List<Autocompletion>> sequenceOfCompletions = autocompletion.getSequenceOfCompletions();
        Rule sequence = autocompletion.getSequence();
        StringBuilder insertionString = new StringBuilder();
        int i = 0;
        for (List<Autocompletion> autocompletions : sequenceOfCompletions) {
            int n = autocompletions.size();
            if (n > 1) {
                String name = sequence.getChildren()[i].getName();
                Autocompletion.Parameterized p = new Autocompletion.Parameterized(sequence.getChildren()[i].getSymbol(), name, name);
                int i0 = offset + insertionString.length();
                int i1 = i0 + name.length();
                ret.add(new ParsedParam(name, i0, i1, p, autocompletions));
                insertionString.append(name);
            } else if (n == 1) {
                Autocompletion single = autocompletions.get(0);
                if (single instanceof Autocompletion.Literal) {
                    insertionString.append(single.getCompletion(Autocompletion.Purpose.FOR_INSERTION));
                } else if (single instanceof Autocompletion.Parameterized) {
                    Autocompletion.Parameterized parameterized = (Autocompletion.Parameterized)single;
                    String s = parameterized.paramName;
                    int i0 = offset + insertionString.length();
                    int i1 = i0 + s.length();
                    ret.add(new ParsedParam(s, i0, i1, parameterized, Collections.singletonList(parameterized)));
                    insertionString.append(s);
                } else if (single instanceof Autocompletion.EntireSequence) {
                    Autocompletion.EntireSequence entire = (Autocompletion.EntireSequence)single;
                    int offs = offset + insertionString.length();
                    String s = ParameterizedCompletionContext.parseParameters(entire, ret, offs);
                    insertionString.append(s);
                } else {
                    System.err.println("Unknown/unexpected autocompletion");
                }
            }
            ++i;
        }
        return insertionString.toString();
    }

    public static interface ParameterChangeListener {
        public void parameterChanged(ParameterizedCompletionContext var1, int var2, boolean var3);
    }

    public static class Param {
        private final String name;
        public final Autocompletion.Parameterized parameterizedCompletion;
        public final List<Autocompletion> allOptions;
        private final Highlighter.Highlight highlight;
        private final Object highlightTag;

        public Param(String name, Autocompletion.Parameterized parameterizedCompletion, List<Autocompletion> allOptions, Highlighter.Highlight highlight, Object highlightTag) {
            this.name = name;
            this.parameterizedCompletion = parameterizedCompletion;
            this.allOptions = allOptions;
            this.highlight = highlight;
            this.highlightTag = highlightTag;
        }

        public String toString() {
            return this.name + ": [" + this.highlight.getStartOffset() + ", " + this.highlight.getEndOffset() + "[";
        }
    }

    public static class ParsedParam {
        public final String name;
        public final int i0;
        public final int i1;
        public final Autocompletion.Parameterized parameterizedCompletion;
        public final List<Autocompletion> allOptions;

        public ParsedParam(String name, int i0, int i1, Autocompletion.Parameterized parameterizedCompletion, List<Autocompletion> allOptions) {
            this.name = name;
            this.i0 = i0;
            this.i1 = i1;
            this.parameterizedCompletion = parameterizedCompletion;
            this.allOptions = allOptions;
        }
    }
}

