/*
 * Decompiled with CFR 0.152.
 */
package nlScript.util;

import java.util.ArrayList;
import java.util.Random;

public class RandomInt {
    public static int next(int from, int to) {
        long origin = from;
        long bound = (long)to + 1L;
        return (int)RandomInt.boundedNextLong(origin, bound);
    }

    public static int[] nextRandomDistinctValues(int from, int to, int n) {
        boolean[] chosen = new boolean[to - from + 1];
        int[] ret = new int[n];
        for (int i = 0; i < n; ++i) {
            int v;
            while (chosen[(v = RandomInt.next(from, to)) - from]) {
            }
            chosen[v] = true;
            ret[i] = v;
        }
        return ret;
    }

    public static <T> void nextRandomDistinctEntries(T[] collection, int n, T[] ret) {
        int[] indices = RandomInt.nextRandomDistinctValues(0, collection.length - 1, n);
        for (int i = 0; i < n; ++i) {
            ret[i] = collection[indices[i]];
        }
    }

    public static <T> ArrayList<T> nextRandomDistinctEntries(ArrayList<T> collection, int n) {
        ArrayList<T> ret = new ArrayList<T>();
        int[] indices = RandomInt.nextRandomDistinctValues(0, collection.size() - 1, n);
        for (int i = 0; i < n; ++i) {
            ret.add(collection.get(indices[i]));
        }
        return ret;
    }

    private static long boundedNextLong(long origin, long bound) {
        Random rng = new Random();
        long r = rng.nextLong();
        if (origin < bound) {
            long n = bound - origin;
            long m = n - 1L;
            if ((n & m) == 0L) {
                r = (r & m) + origin;
            } else if (n > 0L) {
                long u = r >>> 1;
                while (u + m - (r = u % n) < 0L) {
                    u = rng.nextLong() >>> 1;
                }
                r += origin;
            } else {
                while (r < origin || r >= bound) {
                    r = rng.nextLong();
                }
            }
        }
        return r;
    }

    public static void main(String[] args) {
        int i;
        int min = 0;
        int max = 5;
        int[] histo = new int[6];
        for (i = 0; i < 3000; ++i) {
            int r;
            int n = r = RandomInt.next(min, max);
            histo[n] = histo[n] + 1;
        }
        for (i = 0; i < histo.length; ++i) {
            System.out.println(histo[i]);
        }
    }
}

