/*
 * Decompiled with CFR 0.152.
 */
package io.github.oitstack.goblin.runtime;

import io.github.oitstack.goblin.runtime.Runtime;
import io.github.oitstack.goblin.runtime.config.Configure;
import io.github.oitstack.goblin.runtime.utils.MixAll;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class RuntimeAdapter<T extends RuntimeAdapter<T>>
implements Runtime<T> {
    protected Configure configure;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private Function<Supplier, Object> ensureInit = supplier -> {
        this.init();
        return supplier.get();
    };

    public T self() {
        return (T)this;
    }

    @Override
    public T config(Configure configure) {
        this.configure = configure;
        return this.self();
    }

    @Override
    public T init() {
        if (this.initialized.compareAndSet(false, true)) {
            if (null == this.configure) {
                this.configure = MixAll.getMixConfigureBuilder().build();
            }
            this.doInit();
        }
        return this.self();
    }

    protected abstract void doInit();

    protected abstract CompletableFuture<Runtime> doStart();

    @Override
    public T start() {
        boolean i = false;
        return (T)((RuntimeAdapter)this.ensureInit.apply(() -> {
            try {
                return this.startAsync().get(this.configure.getCreateRuntimeTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
    }

    @Override
    public CompletableFuture<T> startAsync() {
        return (CompletableFuture)this.ensureInit.apply(() -> this.doStart());
    }
}

