/*
 * Decompiled with CFR 0.152.
 */
package io.github.oitstack.goblin.runtime.config;

import com.github.dockerjava.core.DefaultDockerClientConfig;
import io.github.oitstack.goblin.runtime.docker.host.DockerHostSelector;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;

public final class RunTimeConfig {
    public static final String RUNTIME_CONFIG_PREFIX = "GOBLIN_RUNTIME_";
    private static final String CONFIG_FILE_PATH = "goblin_runtime.properties";
    public static final String AUTH_CONFIGS = "GOBLIN_RUNTIME_DOCKER_AUTH_CONFIG";
    public static final String PREFIX_PROPERTY_KEY = "GOBLIN_RUNTIME_default_docker_hub";
    public static final String DOCKER_SOCKET_OVERRIDE = "GOBLIN_RUNTIME__docker_socket_override";
    public static final String REUSE_CONTAINER_ENABLE = "GOBLIN_RUNTIME_reuse_container_enable";
    public static final String DAMOCLES_TAG = "GOBLIN_RUNTIME_DAMOCLES_TAG";
    public static final String DOCKER_HOST_PREFIX = "tcp://";
    Properties properties = this.loadConfig();

    public static RunTimeConfig getInstance() {
        return GlobalConfigHolder.INSTANCE;
    }

    private RunTimeConfig() {
    }

    private Properties loadConfig() {
        Properties properties = new Properties();
        this.overrideFromEnv(properties);
        this.overrideFromSystemProperty(properties);
        this.overrideFromConfigFile(properties);
        this.overrideDockerHost(properties);
        return properties;
    }

    private void overrideDockerHost(Properties properties) {
        String selectedDockerHost = DockerHostSelector.getInstance().getSelectedDockerHost();
        properties.put("GOBLIN_RUNTIME_DOCKER_HOST", DOCKER_HOST_PREFIX + selectedDockerHost);
    }

    private void overrideFromConfigFile(Properties properties) {
        Properties prosFromConfigFile = new Properties();
        try (InputStream is = DefaultDockerClientConfig.class.getResourceAsStream("/goblin_runtime.properties");){
            if (is != null) {
                prosFromConfigFile.load(is);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        RunTimeConfig.replaceProperties(prosFromConfigFile, properties);
        prosFromConfigFile.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            if (!(k instanceof String) || !(v instanceof String)) {
                return;
            }
            properties.put(k, v);
        }));
    }

    private void overrideFromSystemProperty(Properties properties) {
        Properties systemProperties = System.getProperties();
        if (null != systemProperties) {
            systemProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                if (!(k instanceof String) || !(v instanceof String)) {
                    return;
                }
                properties.put(k, v);
            }));
        }
    }

    private void overrideFromEnv(Properties properties) {
        Map<String, String> envMap = System.getenv();
        if (null != envMap) {
            envMap.entrySet().stream().filter(e -> e.getKey() != null).forEach(e -> properties.put(e.getKey(), e.getValue()));
        }
    }

    private static void replaceProperties(Properties configProperties, Properties replacements) {
        for (Object objectKey : configProperties.keySet()) {
            String key = objectKey.toString();
            configProperties.setProperty(key, RunTimeConfig.replaceProperties(configProperties.getProperty(key), replacements));
        }
    }

    private static String replaceProperties(String s, Properties replacements) {
        for (Map.Entry<Object, Object> entry : replacements.entrySet()) {
            String key = "${" + entry.getKey() + "}";
            while (s.contains(key)) {
                s = s.replace(key, String.valueOf(entry.getValue()));
            }
        }
        return s;
    }

    public Properties getAllProperties() {
        return this.properties;
    }

    public String get(String key) {
        return this.properties.getProperty(key);
    }

    public String getOrDefault(String key, String def) {
        return this.properties.getProperty(key) != null ? this.properties.getProperty(key) : def;
    }

    public boolean getContainerEnableReuseFlag() {
        return Boolean.parseBoolean(this.getOrDefault(REUSE_CONTAINER_ENABLE, "false"));
    }

    public String getDamoclesTag() {
        return this.get(DAMOCLES_TAG);
    }

    static class GlobalConfigHolder {
        static RunTimeConfig INSTANCE = new RunTimeConfig();

        GlobalConfigHolder() {
        }
    }
}

