/*
 * Decompiled with CFR 0.152.
 */
package io.github.oitstack.goblin.runtime.docker.client;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.AttachContainerCmd;
import com.github.dockerjava.api.command.AuthCmd;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.command.CommitCmd;
import com.github.dockerjava.api.command.ConnectToNetworkCmd;
import com.github.dockerjava.api.command.ContainerDiffCmd;
import com.github.dockerjava.api.command.CopyArchiveFromContainerCmd;
import com.github.dockerjava.api.command.CopyArchiveToContainerCmd;
import com.github.dockerjava.api.command.CopyFileFromContainerCmd;
import com.github.dockerjava.api.command.CreateConfigCmd;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateImageCmd;
import com.github.dockerjava.api.command.CreateNetworkCmd;
import com.github.dockerjava.api.command.CreateSecretCmd;
import com.github.dockerjava.api.command.CreateServiceCmd;
import com.github.dockerjava.api.command.CreateVolumeCmd;
import com.github.dockerjava.api.command.DisconnectFromNetworkCmd;
import com.github.dockerjava.api.command.EventsCmd;
import com.github.dockerjava.api.command.ExecCreateCmd;
import com.github.dockerjava.api.command.ExecStartCmd;
import com.github.dockerjava.api.command.InfoCmd;
import com.github.dockerjava.api.command.InitializeSwarmCmd;
import com.github.dockerjava.api.command.InspectConfigCmd;
import com.github.dockerjava.api.command.InspectContainerCmd;
import com.github.dockerjava.api.command.InspectExecCmd;
import com.github.dockerjava.api.command.InspectImageCmd;
import com.github.dockerjava.api.command.InspectNetworkCmd;
import com.github.dockerjava.api.command.InspectServiceCmd;
import com.github.dockerjava.api.command.InspectSwarmCmd;
import com.github.dockerjava.api.command.InspectVolumeCmd;
import com.github.dockerjava.api.command.JoinSwarmCmd;
import com.github.dockerjava.api.command.KillContainerCmd;
import com.github.dockerjava.api.command.LeaveSwarmCmd;
import com.github.dockerjava.api.command.ListConfigsCmd;
import com.github.dockerjava.api.command.ListContainersCmd;
import com.github.dockerjava.api.command.ListImagesCmd;
import com.github.dockerjava.api.command.ListNetworksCmd;
import com.github.dockerjava.api.command.ListSecretsCmd;
import com.github.dockerjava.api.command.ListServicesCmd;
import com.github.dockerjava.api.command.ListSwarmNodesCmd;
import com.github.dockerjava.api.command.ListTasksCmd;
import com.github.dockerjava.api.command.ListVolumesCmd;
import com.github.dockerjava.api.command.LoadImageCmd;
import com.github.dockerjava.api.command.LogContainerCmd;
import com.github.dockerjava.api.command.LogSwarmObjectCmd;
import com.github.dockerjava.api.command.PauseContainerCmd;
import com.github.dockerjava.api.command.PingCmd;
import com.github.dockerjava.api.command.PruneCmd;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.command.PushImageCmd;
import com.github.dockerjava.api.command.RemoveConfigCmd;
import com.github.dockerjava.api.command.RemoveContainerCmd;
import com.github.dockerjava.api.command.RemoveImageCmd;
import com.github.dockerjava.api.command.RemoveNetworkCmd;
import com.github.dockerjava.api.command.RemoveSecretCmd;
import com.github.dockerjava.api.command.RemoveServiceCmd;
import com.github.dockerjava.api.command.RemoveSwarmNodeCmd;
import com.github.dockerjava.api.command.RemoveVolumeCmd;
import com.github.dockerjava.api.command.RenameContainerCmd;
import com.github.dockerjava.api.command.ResizeContainerCmd;
import com.github.dockerjava.api.command.ResizeExecCmd;
import com.github.dockerjava.api.command.RestartContainerCmd;
import com.github.dockerjava.api.command.SaveImageCmd;
import com.github.dockerjava.api.command.SaveImagesCmd;
import com.github.dockerjava.api.command.SearchImagesCmd;
import com.github.dockerjava.api.command.StartContainerCmd;
import com.github.dockerjava.api.command.StatsCmd;
import com.github.dockerjava.api.command.StopContainerCmd;
import com.github.dockerjava.api.command.TagImageCmd;
import com.github.dockerjava.api.command.TopContainerCmd;
import com.github.dockerjava.api.command.UnpauseContainerCmd;
import com.github.dockerjava.api.command.UpdateContainerCmd;
import com.github.dockerjava.api.command.UpdateServiceCmd;
import com.github.dockerjava.api.command.UpdateSwarmCmd;
import com.github.dockerjava.api.command.UpdateSwarmNodeCmd;
import com.github.dockerjava.api.command.VersionCmd;
import com.github.dockerjava.api.command.WaitContainerCmd;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.Identifier;
import com.github.dockerjava.api.model.Info;
import com.github.dockerjava.api.model.PruneType;
import com.github.dockerjava.api.model.SecretSpec;
import com.github.dockerjava.api.model.ServiceSpec;
import com.github.dockerjava.api.model.SwarmSpec;
import com.github.dockerjava.api.model.Version;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.transport.SSLConfig;
import com.github.dockerjava.zerodep.ZerodepDockerHttpClient;
import io.github.oitstack.goblin.runtime.config.RunTimeConfig;
import io.github.oitstack.goblin.runtime.docker.client.DamoclesManager;
import io.github.oitstack.goblin.runtime.docker.client.GoblinDockerClient;
import io.github.oitstack.goblin.runtime.docker.client.GoblinDockerClientConfig;
import io.github.oitstack.goblin.runtime.docker.utils.DockerUtils;
import io.github.oitstack.goblin.runtime.utils.PropertyAndEnvUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;

public class AutoRecycleDockerClient
implements GoblinDockerClient {
    private static final String LABEL_NAME_GROUP = "group";
    private DockerClient client;
    private DamoclesManager damoclesManager;
    private boolean needStartDamocles = !"false".equals(PropertyAndEnvUtils.get("enable_damocles"));
    private MetaData metaData;

    private AutoRecycleDockerClient() {
        this.initRightVersionClient(RemoteApiVersion.VERSION_1_20, 0, 3);
        if (this.needStartDamocles) {
            this.damoclesManager = new DamoclesManager(this.client);
            this.damoclesManager.startAndRegisterClient(this.metaData.getClientIdentify(), this.metaData.getDockerHost());
        }
    }

    private void initRightVersionClient(RemoteApiVersion remoteApiVersion, int retries, int maxRetries) {
        if (retries >= maxRetries) {
            return;
        }
        Properties p = this.getDockerProperties();
        GoblinDockerClientConfig.Builder dccb = new GoblinDockerClientConfig.Builder().withProperties(p).withApiVersion(remoteApiVersion);
        GoblinDockerClientConfig dcc = dccb.build();
        ZerodepDockerHttpClient dockerHttpClient = new ZerodepDockerHttpClient.Builder().dockerHost(dcc.getDockerHost()).sslConfig((SSLConfig)dcc.getSSLConfig()).build();
        this.client = DockerClientImpl.getInstance((DockerClientConfig)dcc, (DockerHttpClient)dockerHttpClient);
        Info dockerInfo = (Info)this.client.infoCmd().exec();
        Version version = (Version)this.client.versionCmd().exec();
        RemoteApiVersion realVersion = RemoteApiVersion.parseConfig((String)version.getApiVersion());
        if (realVersion.isGreater(remoteApiVersion)) {
            this.initRightVersionClient(realVersion, retries++, maxRetries);
        }
        this.metaData = new MetaData(dcc.getDockerHost(), dockerInfo, version, this.client);
    }

    private Properties getDockerProperties() {
        Properties p = new Properties();
        RunTimeConfig.getInstance().getAllProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String key = (String)k;
            if (key.startsWith("GOBLIN_RUNTIME_")) {
                p.put(key.substring("GOBLIN_RUNTIME_".length()), v);
            }
        }));
        return p;
    }

    public static AutoRecycleDockerClient getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public CreateContainerCmd createContainerCmd(String image) {
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put(LABEL_NAME_GROUP, this.getMetaData().getClientIdentify());
        return this.client.createContainerCmd(image).withLabels(labels);
    }

    @Override
    public String getDockerHostIpAddress() {
        return this.getMetaData().getDockerHostIpAddress();
    }

    public DockerClient getClient() {
        return this.client;
    }

    public DamoclesManager getDamoclesManager() {
        return this.damoclesManager;
    }

    public boolean isNeedStartDamocles() {
        return this.needStartDamocles;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public void setClient(DockerClient client) {
        this.client = client;
    }

    public void setDamoclesManager(DamoclesManager damoclesManager) {
        this.damoclesManager = damoclesManager;
    }

    public void setNeedStartDamocles(boolean needStartDamocles) {
        this.needStartDamocles = needStartDamocles;
    }

    public void setMetaData(MetaData metaData) {
        this.metaData = metaData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoRecycleDockerClient)) {
            return false;
        }
        AutoRecycleDockerClient other = (AutoRecycleDockerClient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isNeedStartDamocles() != other.isNeedStartDamocles()) {
            return false;
        }
        DockerClient this$client = this.getClient();
        DockerClient other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        DamoclesManager this$damoclesManager = this.getDamoclesManager();
        DamoclesManager other$damoclesManager = other.getDamoclesManager();
        if (this$damoclesManager == null ? other$damoclesManager != null : !this$damoclesManager.equals(other$damoclesManager)) {
            return false;
        }
        MetaData this$metaData = this.getMetaData();
        MetaData other$metaData = other.getMetaData();
        return !(this$metaData == null ? other$metaData != null : !((Object)this$metaData).equals(other$metaData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AutoRecycleDockerClient;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNeedStartDamocles() ? 79 : 97);
        DockerClient $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        DamoclesManager $damoclesManager = this.getDamoclesManager();
        result = result * 59 + ($damoclesManager == null ? 43 : $damoclesManager.hashCode());
        MetaData $metaData = this.getMetaData();
        result = result * 59 + ($metaData == null ? 43 : ((Object)$metaData).hashCode());
        return result;
    }

    public String toString() {
        return "AutoRecycleDockerClient(client=" + this.getClient() + ", damoclesManager=" + this.getDamoclesManager() + ", needStartDamocles=" + this.isNeedStartDamocles() + ", metaData=" + this.getMetaData() + ")";
    }

    public AuthConfig authConfig() throws DockerException {
        return this.getClient().authConfig();
    }

    public AuthCmd authCmd() {
        return this.getClient().authCmd();
    }

    public InfoCmd infoCmd() {
        return this.getClient().infoCmd();
    }

    public PingCmd pingCmd() {
        return this.getClient().pingCmd();
    }

    public VersionCmd versionCmd() {
        return this.getClient().versionCmd();
    }

    public PullImageCmd pullImageCmd(String arg0) {
        return this.getClient().pullImageCmd(arg0);
    }

    public PushImageCmd pushImageCmd(String arg0) {
        return this.getClient().pushImageCmd(arg0);
    }

    public PushImageCmd pushImageCmd(Identifier arg0) {
        return this.getClient().pushImageCmd(arg0);
    }

    public CreateImageCmd createImageCmd(String arg0, InputStream arg1) {
        return this.getClient().createImageCmd(arg0, arg1);
    }

    public LoadImageCmd loadImageCmd(InputStream arg0) {
        return this.getClient().loadImageCmd(arg0);
    }

    public SearchImagesCmd searchImagesCmd(String arg0) {
        return this.getClient().searchImagesCmd(arg0);
    }

    public RemoveImageCmd removeImageCmd(String arg0) {
        return this.getClient().removeImageCmd(arg0);
    }

    public ListImagesCmd listImagesCmd() {
        return this.getClient().listImagesCmd();
    }

    public InspectImageCmd inspectImageCmd(String arg0) {
        return this.getClient().inspectImageCmd(arg0);
    }

    public SaveImageCmd saveImageCmd(String arg0) {
        return this.getClient().saveImageCmd(arg0);
    }

    public SaveImagesCmd saveImagesCmd() {
        return this.getClient().saveImagesCmd();
    }

    public ListContainersCmd listContainersCmd() {
        return this.getClient().listContainersCmd();
    }

    public StartContainerCmd startContainerCmd(String arg0) {
        return this.getClient().startContainerCmd(arg0);
    }

    public ExecCreateCmd execCreateCmd(String arg0) {
        return this.getClient().execCreateCmd(arg0);
    }

    public ResizeExecCmd resizeExecCmd(String arg0) {
        return this.getClient().resizeExecCmd(arg0);
    }

    public InspectContainerCmd inspectContainerCmd(String arg0) {
        return this.getClient().inspectContainerCmd(arg0);
    }

    public RemoveContainerCmd removeContainerCmd(String arg0) {
        return this.getClient().removeContainerCmd(arg0);
    }

    public WaitContainerCmd waitContainerCmd(String arg0) {
        return this.getClient().waitContainerCmd(arg0);
    }

    public AttachContainerCmd attachContainerCmd(String arg0) {
        return this.getClient().attachContainerCmd(arg0);
    }

    public ExecStartCmd execStartCmd(String arg0) {
        return this.getClient().execStartCmd(arg0);
    }

    public InspectExecCmd inspectExecCmd(String arg0) {
        return this.getClient().inspectExecCmd(arg0);
    }

    public LogContainerCmd logContainerCmd(String arg0) {
        return this.getClient().logContainerCmd(arg0);
    }

    public CopyArchiveFromContainerCmd copyArchiveFromContainerCmd(String arg0, String arg1) {
        return this.getClient().copyArchiveFromContainerCmd(arg0, arg1);
    }

    @Deprecated
    public CopyFileFromContainerCmd copyFileFromContainerCmd(String arg0, String arg1) {
        return this.getClient().copyFileFromContainerCmd(arg0, arg1);
    }

    public CopyArchiveToContainerCmd copyArchiveToContainerCmd(String arg0) {
        return this.getClient().copyArchiveToContainerCmd(arg0);
    }

    public ContainerDiffCmd containerDiffCmd(String arg0) {
        return this.getClient().containerDiffCmd(arg0);
    }

    public StopContainerCmd stopContainerCmd(String arg0) {
        return this.getClient().stopContainerCmd(arg0);
    }

    public KillContainerCmd killContainerCmd(String arg0) {
        return this.getClient().killContainerCmd(arg0);
    }

    public UpdateContainerCmd updateContainerCmd(String arg0) {
        return this.getClient().updateContainerCmd(arg0);
    }

    public RenameContainerCmd renameContainerCmd(String arg0) {
        return this.getClient().renameContainerCmd(arg0);
    }

    public RestartContainerCmd restartContainerCmd(String arg0) {
        return this.getClient().restartContainerCmd(arg0);
    }

    public ResizeContainerCmd resizeContainerCmd(String arg0) {
        return this.getClient().resizeContainerCmd(arg0);
    }

    public CommitCmd commitCmd(String arg0) {
        return this.getClient().commitCmd(arg0);
    }

    public BuildImageCmd buildImageCmd() {
        return this.getClient().buildImageCmd();
    }

    public BuildImageCmd buildImageCmd(File arg0) {
        return this.getClient().buildImageCmd(arg0);
    }

    public BuildImageCmd buildImageCmd(InputStream arg0) {
        return this.getClient().buildImageCmd(arg0);
    }

    public TopContainerCmd topContainerCmd(String arg0) {
        return this.getClient().topContainerCmd(arg0);
    }

    public TagImageCmd tagImageCmd(String arg0, String arg1, String arg2) {
        return this.getClient().tagImageCmd(arg0, arg1, arg2);
    }

    public PauseContainerCmd pauseContainerCmd(String arg0) {
        return this.getClient().pauseContainerCmd(arg0);
    }

    public UnpauseContainerCmd unpauseContainerCmd(String arg0) {
        return this.getClient().unpauseContainerCmd(arg0);
    }

    public EventsCmd eventsCmd() {
        return this.getClient().eventsCmd();
    }

    public StatsCmd statsCmd(String arg0) {
        return this.getClient().statsCmd(arg0);
    }

    public CreateVolumeCmd createVolumeCmd() {
        return this.getClient().createVolumeCmd();
    }

    public InspectVolumeCmd inspectVolumeCmd(String arg0) {
        return this.getClient().inspectVolumeCmd(arg0);
    }

    public RemoveVolumeCmd removeVolumeCmd(String arg0) {
        return this.getClient().removeVolumeCmd(arg0);
    }

    public ListVolumesCmd listVolumesCmd() {
        return this.getClient().listVolumesCmd();
    }

    public ListNetworksCmd listNetworksCmd() {
        return this.getClient().listNetworksCmd();
    }

    public InspectNetworkCmd inspectNetworkCmd() {
        return this.getClient().inspectNetworkCmd();
    }

    public CreateNetworkCmd createNetworkCmd() {
        return this.getClient().createNetworkCmd();
    }

    public RemoveNetworkCmd removeNetworkCmd(String arg0) {
        return this.getClient().removeNetworkCmd(arg0);
    }

    public ConnectToNetworkCmd connectToNetworkCmd() {
        return this.getClient().connectToNetworkCmd();
    }

    public DisconnectFromNetworkCmd disconnectFromNetworkCmd() {
        return this.getClient().disconnectFromNetworkCmd();
    }

    public InitializeSwarmCmd initializeSwarmCmd(SwarmSpec arg0) {
        return this.getClient().initializeSwarmCmd(arg0);
    }

    public InspectSwarmCmd inspectSwarmCmd() {
        return this.getClient().inspectSwarmCmd();
    }

    public JoinSwarmCmd joinSwarmCmd() {
        return this.getClient().joinSwarmCmd();
    }

    public LeaveSwarmCmd leaveSwarmCmd() {
        return this.getClient().leaveSwarmCmd();
    }

    public UpdateSwarmCmd updateSwarmCmd(SwarmSpec arg0) {
        return this.getClient().updateSwarmCmd(arg0);
    }

    public UpdateSwarmNodeCmd updateSwarmNodeCmd() {
        return this.getClient().updateSwarmNodeCmd();
    }

    public RemoveSwarmNodeCmd removeSwarmNodeCmd(String arg0) {
        return this.getClient().removeSwarmNodeCmd(arg0);
    }

    public ListSwarmNodesCmd listSwarmNodesCmd() {
        return this.getClient().listSwarmNodesCmd();
    }

    public ListServicesCmd listServicesCmd() {
        return this.getClient().listServicesCmd();
    }

    public CreateServiceCmd createServiceCmd(ServiceSpec arg0) {
        return this.getClient().createServiceCmd(arg0);
    }

    public InspectServiceCmd inspectServiceCmd(String arg0) {
        return this.getClient().inspectServiceCmd(arg0);
    }

    public UpdateServiceCmd updateServiceCmd(String arg0, ServiceSpec arg1) {
        return this.getClient().updateServiceCmd(arg0, arg1);
    }

    public RemoveServiceCmd removeServiceCmd(String arg0) {
        return this.getClient().removeServiceCmd(arg0);
    }

    public ListTasksCmd listTasksCmd() {
        return this.getClient().listTasksCmd();
    }

    public LogSwarmObjectCmd logServiceCmd(String arg0) {
        return this.getClient().logServiceCmd(arg0);
    }

    public LogSwarmObjectCmd logTaskCmd(String arg0) {
        return this.getClient().logTaskCmd(arg0);
    }

    public PruneCmd pruneCmd(PruneType arg0) {
        return this.getClient().pruneCmd(arg0);
    }

    public ListSecretsCmd listSecretsCmd() {
        return this.getClient().listSecretsCmd();
    }

    public CreateSecretCmd createSecretCmd(SecretSpec arg0) {
        return this.getClient().createSecretCmd(arg0);
    }

    public RemoveSecretCmd removeSecretCmd(String arg0) {
        return this.getClient().removeSecretCmd(arg0);
    }

    public ListConfigsCmd listConfigsCmd() {
        return this.getClient().listConfigsCmd();
    }

    public CreateConfigCmd createConfigCmd() {
        return this.getClient().createConfigCmd();
    }

    public InspectConfigCmd inspectConfigCmd(String arg0) {
        return this.getClient().inspectConfigCmd(arg0);
    }

    public RemoveConfigCmd removeConfigCmd(String arg0) {
        return this.getClient().removeConfigCmd(arg0);
    }

    public void close() throws IOException {
        this.getClient().close();
    }

    public static class MetaData {
        private URI dockerHost;
        private Info dockerInfo;
        private Version version;
        private DockerClient refDockerClient;
        private final AtomicReference<Object> dockerHostIpAddress = new AtomicReference();
        private String clientIdentify = UUID.randomUUID().toString();

        public String resolve() {
            return DockerUtils.getDockerHostIpAddress(this.refDockerClient, this.dockerHost);
        }

        public MetaData(URI dockerHost, Info dockerInfo, Version version, DockerClient refDockerClient) {
            this.dockerHost = dockerHost;
            this.dockerInfo = dockerInfo;
            this.version = version;
            this.refDockerClient = refDockerClient;
        }

        public String getClientIdentify() {
            return this.clientIdentify;
        }

        public URI getDockerHost() {
            return this.dockerHost;
        }

        public Info getDockerInfo() {
            return this.dockerInfo;
        }

        public Version getVersion() {
            return this.version;
        }

        public DockerClient getRefDockerClient() {
            return this.refDockerClient;
        }

        public void setDockerHost(URI dockerHost) {
            this.dockerHost = dockerHost;
        }

        public void setDockerInfo(Info dockerInfo) {
            this.dockerInfo = dockerInfo;
        }

        public void setVersion(Version version) {
            this.version = version;
        }

        public void setRefDockerClient(DockerClient refDockerClient) {
            this.refDockerClient = refDockerClient;
        }

        public void setClientIdentify(String clientIdentify) {
            this.clientIdentify = clientIdentify;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MetaData)) {
                return false;
            }
            MetaData other = (MetaData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            URI this$dockerHost = this.getDockerHost();
            URI other$dockerHost = other.getDockerHost();
            if (this$dockerHost == null ? other$dockerHost != null : !((Object)this$dockerHost).equals(other$dockerHost)) {
                return false;
            }
            Info this$dockerInfo = this.getDockerInfo();
            Info other$dockerInfo = other.getDockerInfo();
            if (this$dockerInfo == null ? other$dockerInfo != null : !this$dockerInfo.equals(other$dockerInfo)) {
                return false;
            }
            Version this$version = this.getVersion();
            Version other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            DockerClient this$refDockerClient = this.getRefDockerClient();
            DockerClient other$refDockerClient = other.getRefDockerClient();
            if (this$refDockerClient == null ? other$refDockerClient != null : !this$refDockerClient.equals(other$refDockerClient)) {
                return false;
            }
            String this$dockerHostIpAddress = this.getDockerHostIpAddress();
            String other$dockerHostIpAddress = other.getDockerHostIpAddress();
            if (this$dockerHostIpAddress == null ? other$dockerHostIpAddress != null : !this$dockerHostIpAddress.equals(other$dockerHostIpAddress)) {
                return false;
            }
            String this$clientIdentify = this.getClientIdentify();
            String other$clientIdentify = other.getClientIdentify();
            return !(this$clientIdentify == null ? other$clientIdentify != null : !this$clientIdentify.equals(other$clientIdentify));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MetaData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            URI $dockerHost = this.getDockerHost();
            result = result * 59 + ($dockerHost == null ? 43 : ((Object)$dockerHost).hashCode());
            Info $dockerInfo = this.getDockerInfo();
            result = result * 59 + ($dockerInfo == null ? 43 : $dockerInfo.hashCode());
            Version $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            DockerClient $refDockerClient = this.getRefDockerClient();
            result = result * 59 + ($refDockerClient == null ? 43 : $refDockerClient.hashCode());
            String $dockerHostIpAddress = this.getDockerHostIpAddress();
            result = result * 59 + ($dockerHostIpAddress == null ? 43 : $dockerHostIpAddress.hashCode());
            String $clientIdentify = this.getClientIdentify();
            result = result * 59 + ($clientIdentify == null ? 43 : $clientIdentify.hashCode());
            return result;
        }

        public String toString() {
            return "AutoRecycleDockerClient.MetaData(dockerHost=" + this.getDockerHost() + ", dockerInfo=" + this.getDockerInfo() + ", version=" + this.getVersion() + ", refDockerClient=" + this.getRefDockerClient() + ", dockerHostIpAddress=" + this.getDockerHostIpAddress() + ", clientIdentify=" + this.getClientIdentify() + ")";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getDockerHostIpAddress() {
            Object value = this.dockerHostIpAddress.get();
            if (value == null) {
                AtomicReference<Object> atomicReference = this.dockerHostIpAddress;
                synchronized (atomicReference) {
                    value = this.dockerHostIpAddress.get();
                    if (value == null) {
                        String actualValue = this.resolve();
                        value = actualValue == null ? this.dockerHostIpAddress : actualValue;
                        this.dockerHostIpAddress.set(value);
                    }
                }
            }
            return (String)(value == this.dockerHostIpAddress ? null : value);
        }
    }

    static interface ExcludeMethods {
        public CreateContainerCmd createContainerCmd(String var1);
    }

    static class InstanceHolder {
        private static AutoRecycleDockerClient INSTANCE = new AutoRecycleDockerClient();

        InstanceHolder() {
        }
    }
}

