/*
 * Decompiled with CFR 0.152.
 */
package io.github.oitstack.goblin.runtime.docker.image.pull.fetchers;

import com.github.dockerjava.api.DockerClient;
import io.github.oitstack.goblin.runtime.docker.image.DockerImageName;
import io.github.oitstack.goblin.runtime.docker.image.pull.fetchers.FetchContext;
import io.github.oitstack.goblin.runtime.docker.image.pull.fetchers.ImageFetcher;
import java.util.List;

public class DirectImageFetcher
implements ImageFetcher {
    @Override
    public FetchContext fetch(DockerImageName dockerImageName, DockerClient dockerClient) {
        FetchContext fetchContext = FetchContext.builder().upStreamResult(false).pulledTimeStamp(System.currentTimeMillis()).build();
        try {
            List imageList = (List)dockerClient.listImagesCmd().withImageNameFilter(dockerImageName.toIdentifyName()).exec();
            if (imageList == null || imageList.isEmpty()) {
                dockerClient.pullImageCmd(dockerImageName.toIdentifyName()).withTag(dockerImageName.getVersion().getVersionDesc()).start().awaitCompletion();
            }
            fetchContext = fetchContext.toBuilder().pulledTimeStamp(System.currentTimeMillis()).upStreamResult(true).build();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            fetchContext = fetchContext.toBuilder().exception(e.getMessage()).pulledTimeStamp(System.currentTimeMillis()).upStreamResult(false).build();
        }
        return fetchContext;
    }
}

