/*
 * Decompiled with CFR 0.152.
 */
package io.github.oitstack.goblin.runtime.docker.image.pull.fetchers.decorators;

import com.github.dockerjava.api.DockerClient;
import io.github.oitstack.goblin.runtime.docker.image.DockerImageName;
import io.github.oitstack.goblin.runtime.docker.image.pull.fetchers.FetchContext;
import io.github.oitstack.goblin.runtime.docker.image.pull.fetchers.ImageFetcher;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;

public class SegmentLockDecorator
implements ImageFetcher {
    ImageFetcher fetcher;
    private int length = 1024;
    private int mask = this.length - 1;
    private Lock[] locks = (Lock[])Stream.generate(ReentrantLock::new).limit(this.length).toArray(Lock[]::new);

    private Lock getLock(int i) {
        return this.locks[i & this.mask];
    }

    public SegmentLockDecorator(ImageFetcher fetcher) {
        this.fetcher = fetcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FetchContext fetch(DockerImageName dockerImageName, DockerClient dockerClient) {
        int lockIndex = Math.abs(dockerImageName.hashCode());
        this.getLock(lockIndex).lock();
        try {
            FetchContext fetchContext = this.fetcher.fetch(dockerImageName, dockerClient);
            return fetchContext;
        }
        finally {
            this.getLock(lockIndex).unlock();
        }
    }
}

