/*
 * Decompiled with CFR 0.152.
 */
package io.github.oitstack.goblin.runtime.docker.utils;

import com.github.dockerjava.api.DockerClient;
import io.github.oitstack.goblin.runtime.docker.utils.DockerUtils;
import io.github.oitstack.goblin.runtime.transfer.MountableFile;
import io.github.oitstack.goblin.runtime.transfer.TransferFile;

public class DockerTransferFile
extends TransferFile {
    private DockerClient dockerClient;

    public DockerTransferFile(DockerClient dockerClient, MountableFile mf) {
        super(mf);
        this.dockerClient = dockerClient;
    }

    public static DockerTransferFile forHostPath(DockerClient dockerClient, String filePath) {
        return new DockerTransferFile(dockerClient, MountableFile.generateFromHostPath(filePath));
    }

    @Override
    public void transferTo(String runtimeId, String runtimePath) {
        DockerUtils.transferFileToDocker(this.dockerClient, runtimeId, this.mountableFile, runtimePath);
    }
}

