/*
 * Decompiled with CFR 0.152.
 */
package io.github.oitstack.goblin.runtime.docker.utils;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Network;
import com.github.dockerjava.api.model.Ports;
import io.github.oitstack.goblin.runtime.RuntimeOperation;
import io.github.oitstack.goblin.runtime.docker.utils.ExecResultCallback;
import io.github.oitstack.goblin.runtime.transfer.MountableFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.IOUtils;

public final class DockerUtils {
    public static final boolean IN_A_CONTAINER = new File("/.dockerenv").exists();

    public static Integer getMappedPort(InspectContainerResponse inspectContainerResponse, int originalPort) {
        Ports.Binding[] binding = new Ports.Binding[]{};
        InspectContainerResponse containerInfo = inspectContainerResponse;
        if (containerInfo != null) {
            binding = (Ports.Binding[])containerInfo.getNetworkSettings().getPorts().getBindings().get(new ExposedPort(originalPort));
        }
        if (binding != null && binding.length > 0 && binding[0] != null) {
            return Integer.valueOf(binding[0].getHostPortSpec());
        }
        throw new IllegalArgumentException("Requested port (" + originalPort + ") is not mapped");
    }

    public static Integer getFirstMappedPort(InspectContainerResponse inspectContainerResponse, List<ExposedPort> exposedPorts) {
        return exposedPorts.stream().findFirst().map(t -> DockerUtils.getMappedPort(inspectContainerResponse, t.getPort())).orElseThrow(() -> new IllegalStateException("Container doesn't expose any ports"));
    }

    public static String getDockerHostIpAddress(DockerClient client, URI dockerHost) {
        switch (dockerHost.getScheme()) {
            case "http": 
            case "https": 
            case "tcp": {
                return dockerHost.getHost();
            }
            case "unix": 
            case "npipe": {
                if (IN_A_CONTAINER) {
                    return client.inspectNetworkCmd().withNetworkId("bridge").exec().getIpam().getConfig().stream().filter(it -> it.getGateway() != null).findAny().map(Network.Ipam.Config::getGateway).orElseGet(() -> "localhost");
                }
                return "localhost";
            }
        }
        return null;
    }

    public static void transferFileToDocker(DockerClient dockerClient, String containerId, MountableFile hostFile, String containerFile) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
             TarArchiveOutputStream tarArchive = new TarArchiveOutputStream((OutputStream)byteArrayOutputStream);){
            tarArchive.setLongFileMode(3);
            TarArchiveEntry tarEntry = new TarArchiveEntry(containerFile);
            tarEntry.setSize(hostFile.getSize());
            tarEntry.setMode(hostFile.getFileMode());
            try {
                tarArchive.putArchiveEntry((ArchiveEntry)tarEntry);
                IOUtils.write((byte[])hostFile.getBytes(), (OutputStream)tarArchive);
                tarArchive.closeArchiveEntry();
            }
            catch (IOException e) {
                throw new RuntimeException("Can't transfer " + containerFile, e);
            }
            tarArchive.finish();
            dockerClient.copyArchiveToContainerCmd(containerId).withTarInputStream((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray())).withRemotePath("/").exec();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static RuntimeOperation.ExecResult runCommandInContainer(DockerClient dockerClient, String containerId, String ... commands) {
        ExecCreateCmdResponse execCreateCmdResponse = (ExecCreateCmdResponse)dockerClient.execCreateCmd(containerId).withAttachStdout(Boolean.valueOf(true)).withAttachStderr(Boolean.valueOf(true)).withCmd(commands).exec();
        ExecResultCallback callback = new ExecResultCallback();
        try {
            ((ExecResultCallback)dockerClient.execStartCmd(execCreateCmdResponse.getId()).exec((ResultCallback)callback)).awaitCompletion();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Integer exitCode = dockerClient.inspectExecCmd(execCreateCmdResponse.getId()).exec().getExitCode();
        RuntimeOperation.ExecResult result = new RuntimeOperation.ExecResult(String.valueOf(exitCode), callback.getStdout(), callback.getStderr());
        return result;
    }

    private DockerUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

