/*
 * Decompiled with CFR 0.152.
 */
package io.github.oitstack.goblin.runtime.docker.utils;

import com.github.dockerjava.api.async.ResultCallbackTemplate;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.StreamType;

public class ExecResultCallback
extends ResultCallbackTemplate<ExecResultCallback, Frame> {
    private String stdout;
    private String stderr;

    public void onNext(Frame frame) {
        if (frame.getStreamType() == StreamType.STDOUT) {
            this.stdout = new String(frame.getPayload());
        } else if (frame.getStreamType() == StreamType.STDERR) {
            this.stderr = new String(frame.getPayload());
        }
    }

    public String getStdout() {
        return this.stdout;
    }

    public String getStderr() {
        return this.stderr;
    }

    public void setStdout(String stdout) {
        this.stdout = stdout;
    }

    public void setStderr(String stderr) {
        this.stderr = stderr;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExecResultCallback)) {
            return false;
        }
        ExecResultCallback other = (ExecResultCallback)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$stdout = this.getStdout();
        String other$stdout = other.getStdout();
        if (this$stdout == null ? other$stdout != null : !this$stdout.equals(other$stdout)) {
            return false;
        }
        String this$stderr = this.getStderr();
        String other$stderr = other.getStderr();
        return !(this$stderr == null ? other$stderr != null : !this$stderr.equals(other$stderr));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExecResultCallback;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $stdout = this.getStdout();
        result = result * 59 + ($stdout == null ? 43 : $stdout.hashCode());
        String $stderr = this.getStderr();
        result = result * 59 + ($stderr == null ? 43 : $stderr.hashCode());
        return result;
    }

    public String toString() {
        return "ExecResultCallback(stdout=" + this.getStdout() + ", stderr=" + this.getStderr() + ")";
    }
}

