/*
 * Decompiled with CFR 0.152.
 */
package io.github.oitstack.goblin.runtime.transfer;

import io.github.oitstack.goblin.runtime.transfer.FileModeEnums;
import io.github.oitstack.goblin.runtime.utils.MixAll;
import io.github.oitstack.goblin.runtime.utils.PathUtils;
import io.github.oitstack.goblin.runtime.utils.PlatformUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;

public class FileUtils {
    private static final String OS_MAC_TMP_DIR = "/tmp";
    public static final int DEFAULT_FILE_MODE = FileModeEnums.FILE_644.getMode();
    public static final int DEFAULT_DIR_MODE = FileModeEnums.DIR_755.getMode();

    public static File createTempDirectory(String tempDir) {
        try {
            if (PlatformUtils.IS_MAC) {
                return Files.createTempDirectory(Paths.get(OS_MAC_TMP_DIR, new String[0]), tempDir, new FileAttribute[0]).toFile();
            }
            return Files.createTempDirectory(tempDir, new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            return new File(tempDir + MixAll.randomString(5));
        }
    }

    public static void delete(File file) {
        try {
            file.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void deletePathOnJVMExit(Path path) {
        Runtime.getRuntime().addShutdownHook(MixAll.NAMED_THREAD_FACTORY.newThread(() -> PathUtils.delAllFromDir(path)));
    }

    public static int getUnixFileMode(Path path) {
        try {
            Map<String, Object> fileAttributes = Files.readAttributes(path, "unix:mode", new LinkOption[0]);
            return FileUtils.dealWithIBMMachine(path, (Integer)fileAttributes.get("mode"));
        }
        catch (IOException | UnsupportedOperationException e) {
            int mode = DEFAULT_FILE_MODE;
            mode = Files.isDirectory(path, new LinkOption[0]) ? DEFAULT_DIR_MODE : (Files.isExecutable(path) ? DEFAULT_FILE_MODE | 0x49 : DEFAULT_FILE_MODE);
            return mode;
        }
    }

    private static int dealWithIBMMachine(Path path, int unixMode) {
        if (PlatformUtils.IS_IBM_MACHINE) {
            unixMode = (int)((long)unixMode & 0x1FFFFFL);
            unixMode |= Files.isDirectory(path, new LinkOption[0]) ? 16384 : 32768;
        }
        return unixMode;
    }
}

