/*
 * Decompiled with CFR 0.152.
 */
package io.github.oitstack.goblin.runtime.utils;

import io.github.oitstack.goblin.runtime.config.Configure;
import java.security.SecureRandom;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public class MixAll {
    public static final ThreadFactory NAMED_THREAD_FACTORY = new ThreadFactory(){
        private String NAME_PREFIX = "goblin-thread-";
        private AtomicLong threadSeqNum = new AtomicLong(0L);

        @Override
        public Thread newThread(Runnable runnable) {
            Thread t = new Thread(runnable);
            t.setName(this.NAME_PREFIX + this.threadSeqNum.getAndIncrement());
            return t;
        }
    };
    private static final char[] ALPHABET = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz".toCharArray();
    private static final SecureRandom RANDOM = new SecureRandom();

    public static Configure.ConfigureBuilder getPureConfigureBuilder() {
        return Configure.builder();
    }

    public static Configure.ConfigureBuilder getMixConfigureBuilder() {
        return Configure.builder();
    }

    public static <T> T retry(int retries, Supplier<T> supplier) {
        for (int i = 0; i < retries; ++i) {
            T result = supplier.get();
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static String randomString(int length) {
        char[] result = new char[length];
        for (int i = 0; i < length; ++i) {
            char pick;
            result[i] = pick = ALPHABET[RANDOM.nextInt(ALPHABET.length)];
        }
        return new String(result);
    }
}

