/*
 * Decompiled with CFR 0.152.
 */
package io.github.oitstack.goblin.runtime.docker.client;

import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.core.NameParser;
import io.github.oitstack.goblin.runtime.config.RunTimeConfig;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AuthConfigLocator {
    private Map<NameParser.HostnameReposName, AuthConfig> cache = new ConcurrentHashMap<NameParser.HostnameReposName, AuthConfig>();

    private AuthConfigLocator() {
        this.loadFromGlobalConfig();
    }

    private void loadFromGlobalConfig() {
        String authConfigStr = RunTimeConfig.getInstance().get("GOBLIN_RUNTIME_DOCKER_AUTH_CONFIG");
        if (null == authConfigStr || "".equals(authConfigStr)) {
            return;
        }
    }

    public static AuthConfigLocator getInstance() {
        return AuthConfigLocatorHolder.INSTANCE;
    }

    public AuthConfig locale(NameParser.HostnameReposName hostReposName, AuthConfig defaultAuthConfig) {
        return this.cache.getOrDefault(hostReposName, defaultAuthConfig);
    }

    static class AuthConfigLocatorHolder {
        public static AuthConfigLocator INSTANCE = new AuthConfigLocator();

        AuthConfigLocatorHolder() {
        }
    }
}

