/*
 * Decompiled with CFR 0.152.
 */
package io.github.oitstack.goblin.runtime.docker.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.AuthConfigurations;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.NameParser;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.core.SSLConfig;
import io.github.oitstack.goblin.runtime.docker.client.AuthConfigLocator;
import io.github.oitstack.goblin.runtime.docker.client.GoblinSSLConfig;
import java.io.Serializable;
import java.net.URI;
import java.util.Properties;

public class GoblinDockerClientConfig
implements Serializable,
DockerClientConfig {
    private static final long serialVersionUID = 1L;
    DockerClientConfig dockerClientConfig;

    public GoblinDockerClientConfig(DockerClientConfig dockerClientConfig) {
        this.dockerClientConfig = dockerClientConfig;
    }

    public AuthConfig effectiveAuthConfig(String imageName) {
        NameParser.ReposTag reposTag = NameParser.parseRepositoryTag((String)imageName);
        NameParser.HostnameReposName hostnameReposName = NameParser.resolveRepositoryName((String)reposTag.repos);
        AuthConfig authConfig = AuthConfigLocator.getInstance().locale(hostnameReposName, null);
        if (authConfig != null) {
            return authConfig;
        }
        authConfig = this.dockerClientConfig.effectiveAuthConfig(imageName);
        if (authConfig != null) {
            return authConfig;
        }
        return this.getAuthConfig();
    }

    private AuthConfig getAuthConfig() {
        AuthConfig authConfig = null;
        if (this.getRegistryUsername() != null && this.getRegistryPassword() != null && this.getRegistryUrl() != null) {
            authConfig = new AuthConfig().withUsername(this.getRegistryUsername()).withPassword(this.getRegistryPassword()).withEmail(this.getRegistryEmail()).withRegistryAddress(this.getRegistryUrl());
        }
        return authConfig;
    }

    public URI getDockerHost() {
        return this.dockerClientConfig.getDockerHost();
    }

    public RemoteApiVersion getApiVersion() {
        return this.dockerClientConfig.getApiVersion();
    }

    public String getRegistryUsername() {
        return this.dockerClientConfig.getRegistryUsername();
    }

    public String getRegistryPassword() {
        return this.dockerClientConfig.getRegistryPassword();
    }

    public String getRegistryEmail() {
        return this.dockerClientConfig.getRegistryEmail();
    }

    public String getRegistryUrl() {
        return this.dockerClientConfig.getRegistryUrl();
    }

    public AuthConfigurations getAuthConfigurations() {
        return this.dockerClientConfig.getAuthConfigurations();
    }

    public SSLConfig getSSLConfig() {
        return this.dockerClientConfig.getSSLConfig();
    }

    public ObjectMapper getObjectMapper() {
        return this.dockerClientConfig.getObjectMapper();
    }

    public static class Builder {
        private Boolean dockerTlsVerify;
        private String dockerCerPath;
        private Properties properties;
        private RemoteApiVersion apiVersion;

        public Builder withProperties(Properties p) {
            this.properties = p;
            this.withDockerTlsVerify(p.getProperty("DOCKER_TLS_VERIFY"));
            this.withDockerCertPath(p.getProperty("DOCKER_CERT_PATH"));
            return this;
        }

        public Builder withApiVersion(RemoteApiVersion version) {
            this.apiVersion = version;
            return this;
        }

        public final Builder withDockerTlsVerify(String dockerTlsVerify) {
            String trimmed;
            this.dockerTlsVerify = dockerTlsVerify != null ? Boolean.valueOf("true".equalsIgnoreCase(trimmed = dockerTlsVerify.trim()) || "1".equals(trimmed)) : Boolean.valueOf(false);
            return this;
        }

        private void withDockerCertPath(String dockerCerPath) {
            this.dockerCerPath = dockerCerPath;
        }

        public GoblinDockerClientConfig build() {
            DefaultDockerClientConfig.Builder defaultBuilder = DefaultDockerClientConfig.createDefaultConfigBuilder();
            if (null != this.properties) {
                defaultBuilder.withProperties(this.properties);
            }
            if (null != this.apiVersion) {
                defaultBuilder.withApiVersion(this.apiVersion);
            }
            if (this.dockerTlsVerify.booleanValue()) {
                defaultBuilder.withCustomSslConfig((SSLConfig)new GoblinSSLConfig(this.dockerCerPath));
            }
            return new GoblinDockerClientConfig((DockerClientConfig)defaultBuilder.build());
        }
    }

    static interface ExcludeMethods {
        public AuthConfig effectiveAuthConfig(String var1);
    }
}

