/*
 * Decompiled with CFR 0.152.
 */
package io.github.oitstack.goblin.runtime.docker.client;

import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.core.SSLConfig;
import com.github.dockerjava.core.util.CertificateUtils;
import io.github.oitstack.goblin.runtime.docker.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.security.AccessController;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoblinSSLConfig
implements SSLConfig,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(GoblinSSLConfig.class);
    private static final String DEFAULT_CERT_PATH = "/cert";
    private static final String CA_FILE_NAME = "ca.pem";
    private static final String KEY_FILE_NAME = "key.pem";
    private static final String CERT_FILE_NAME = "cert.pem";
    public static final String DOCKER = "docker";
    public static final String SSL_KEY_MANAGER_FACTORY_ALGORITHM = "ssl.keyManagerFactory.algorithm";
    public static final String SSL_TRUST_MANAGER_FACTORY_ALGORITHM = "ssl.trustManagerFactory.algorithm";
    private String dockerCertPath;

    public GoblinSSLConfig(String dockerCertPath) {
        if (StringUtils.isBlank(dockerCertPath)) {
            dockerCertPath = DEFAULT_CERT_PATH;
        }
        this.dockerCertPath = dockerCertPath;
    }

    public SSLContext getSSLContext() {
        URL resource = GoblinSSLConfig.class.getResource(this.dockerCertPath);
        if (resource == null) {
            LOGGER.warn("there is no configured certificate directory of docker client, dir={}.", (Object)this.dockerCertPath);
            return null;
        }
        if (CertificateUtils.verifyCertificatesExist((String)resource.getPath())) {
            try {
                Security.addProvider((Provider)new BouncyCastleProvider());
                String capem = GoblinSSLConfig.readToString(this.dockerCertPath + "/" + CA_FILE_NAME);
                String keypem = GoblinSSLConfig.readToString(this.dockerCertPath + "/" + KEY_FILE_NAME);
                String certpem = GoblinSSLConfig.readToString(this.dockerCertPath + "/" + CERT_FILE_NAME);
                KeyManagerFactory keyManagerFactory = this.initKeyManagerFactory(keypem, certpem);
                TrustManagerFactory trustManagerFactory = this.initTrustManagerFactory(capem);
                SSLContext sslContext = this.initSSLContext(keyManagerFactory, trustManagerFactory);
                return sslContext;
            }
            catch (Exception var13) {
                throw new DockerClientException(var13.getMessage(), (Throwable)var13);
            }
        }
        LOGGER.warn("there is no certificates of docker client in path {}.", (Object)this.dockerCertPath);
        return null;
    }

    private SSLContext initSSLContext(KeyManagerFactory keyManagerFactory, TrustManagerFactory trustManagerFactory) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        return sslContext;
    }

    private TrustManagerFactory initTrustManagerFactory(String capem) throws NoSuchAlgorithmException, KeyStoreException, IOException, CertificateException {
        String tmfAlgorithm = AccessController.doPrivileged(this.getSystemProperty(SSL_TRUST_MANAGER_FACTORY_ALGORITHM, TrustManagerFactory.getDefaultAlgorithm()));
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(tmfAlgorithm);
        trustManagerFactory.init(CertificateUtils.createTrustStore((String)capem));
        return trustManagerFactory;
    }

    private KeyManagerFactory initKeyManagerFactory(String keypem, String certpem) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, InvalidKeySpecException, IOException, CertificateException {
        String kmfAlgorithm = AccessController.doPrivileged(this.getSystemProperty(SSL_KEY_MANAGER_FACTORY_ALGORITHM, KeyManagerFactory.getDefaultAlgorithm()));
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(kmfAlgorithm);
        keyManagerFactory.init(CertificateUtils.createKeyStore((String)keypem, (String)certpem), DOCKER.toCharArray());
        return keyManagerFactory;
    }

    private PrivilegedAction<String> getSystemProperty(String name, String def) {
        return () -> System.getProperty(name, def);
    }

    public static String readToString(String filePath) {
        File file = new File(GoblinSSLConfig.class.getResource(filePath).getPath());
        Long fileLength = file.length();
        byte[] fileContent = new byte[fileLength.intValue()];
        try (FileInputStream in = new FileInputStream(file);){
            in.read(fileContent);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new String(fileContent);
    }
}

