/*
 * Decompiled with CFR 0.152.
 */
package io.github.oitstack.goblin.runtime.docker.container;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.SELContext;
import com.github.dockerjava.api.model.Volume;
import com.google.common.collect.ImmutableMap;
import io.github.oitstack.goblin.runtime.Runtime;
import io.github.oitstack.goblin.runtime.RuntimeAdapter;
import io.github.oitstack.goblin.runtime.RuntimeOperation;
import io.github.oitstack.goblin.runtime.config.RunTimeConfig;
import io.github.oitstack.goblin.runtime.docker.client.AutoRecycleDockerClient;
import io.github.oitstack.goblin.runtime.docker.client.GoblinDockerClient;
import io.github.oitstack.goblin.runtime.docker.image.DockerImage;
import io.github.oitstack.goblin.runtime.docker.utils.DockerTransferFile;
import io.github.oitstack.goblin.runtime.docker.utils.DockerUtils;
import io.github.oitstack.goblin.runtime.docker.utils.JsonTool;
import io.github.oitstack.goblin.runtime.docker.utils.MD5Util;
import io.github.oitstack.goblin.runtime.docker.utils.StringUtils;
import io.github.oitstack.goblin.runtime.transfer.MountableFile;
import io.github.oitstack.goblin.runtime.transfer.TransferFile;
import io.github.oitstack.goblin.runtime.utils.PlatformUtils;
import io.github.oitstack.goblin.runtime.utils.Preconditions;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerContainerAdapter<T extends DockerContainerAdapter<T>>
extends RuntimeAdapter<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerContainerAdapter.class);
    private GoblinDockerClient goblinDockerClient;
    private final Map<String, String> envs = new HashMap<String, String>();
    private DockerImage image;
    private final List<T> others = new ArrayList<T>();
    private final List<String> commands = new ArrayList<String>();
    private boolean privilegedMode = false;
    private String containerId;
    private final List<Bind> binds = new ArrayList<Bind>();
    private Integer[] exposedPorts = null;
    private Map<TransferFile, String> needCopyFiles = new HashMap<TransferFile, String>();
    private static final String MD5_LABEL = "goblin_container_md5_label";

    public DockerContainerAdapter() {
        this(AutoRecycleDockerClient.getInstance());
    }

    public DockerContainerAdapter(GoblinDockerClient goblinDockerClient) {
        this.goblinDockerClient = goblinDockerClient;
    }

    @Override
    public T image(String image) {
        this.image = DockerImage.parseFrom(image, this.goblinDockerClient);
        return (T)((DockerContainerAdapter)this.self());
    }

    @Override
    public T addLink(T other) {
        this.others.add(other);
        return (T)((DockerContainerAdapter)this.self());
    }

    @Override
    public T addEnv(String key, String value) {
        this.envs.put(key, value);
        return (T)((DockerContainerAdapter)this.self());
    }

    @Override
    public T addCommandWhenStartup(String command) {
        this.commands.add(command);
        return (T)((DockerContainerAdapter)this.self());
    }

    @Override
    public T privilegedMode(boolean privilegedMode) {
        this.privilegedMode = privilegedMode;
        return (T)((DockerContainerAdapter)this.self());
    }

    public T addBind(Bind bind) {
        this.binds.add(bind);
        return (T)((DockerContainerAdapter)this.self());
    }

    @Override
    public T exposedPorts(Integer[] ports) {
        this.exposedPorts = ports;
        return (T)((DockerContainerAdapter)this.self());
    }

    @Override
    public String getHost() {
        return this.goblinDockerClient.getDockerHostIpAddress();
    }

    @Override
    public Integer getPortByInnerPort(Integer innerPort) {
        InspectContainerResponse inspectContainerResponse = this.goblinDockerClient.inspectContainerCmd(this.containerId).exec();
        return DockerUtils.getFirstMappedPort(inspectContainerResponse, Arrays.asList(new ExposedPort(innerPort.intValue())));
    }

    @Override
    public String getImageName() {
        return this.image.getImageName().toIdentifyName();
    }

    @Override
    public String getEnv(String key) {
        return this.envs.get(key);
    }

    @Override
    public String getRuntimeId() {
        return this.containerId;
    }

    @Override
    public boolean getPrivilegedMode() {
        return this.privilegedMode;
    }

    @Override
    public List<Bind> getBinds() {
        return this.binds;
    }

    @Override
    public boolean isRunning() {
        InspectContainerResponse inspectContainerResponse = this.goblinDockerClient.inspectContainerCmd(this.containerId).exec();
        return inspectContainerResponse != null && inspectContainerResponse.getState() != null && inspectContainerResponse.getState().getRunning() != false;
    }

    @Override
    protected void doInit() {
    }

    @Override
    public CompletableFuture<Runtime> doStart() {
        Preconditions.checkNotNull(this.image, "image cannot be null");
        CompletableFuture<Runtime> result = new CompletableFuture<Runtime>();
        this.image.getPulled().whenComplete((r, ex) -> {
            if (null != ex) {
                result.completeExceptionally((Throwable)ex);
                return;
            }
            try {
                CreateContainerCmd createContainerCmd = this.buildCreateCommand();
                String label = this.encodeCommandExceptForGroup(createContainerCmd);
                if (RunTimeConfig.getInstance().getContainerEnableReuseFlag()) {
                    this.containerId = this.findContainerByLabel(label);
                }
                if (StringUtils.isBlank(this.containerId)) {
                    createContainerCmd.getLabels().put(MD5_LABEL, label);
                    this.containerId = createContainerCmd.exec().getId();
                    this.doCopyFileToContainerWhenStartup();
                    this.containerPreStart();
                    this.goblinDockerClient.startContainerCmd(this.containerId).exec();
                    this.blockUntilContainerStarted();
                    this.containerStarted();
                } else {
                    LOGGER.info("reuse container, imageInfo={}, containerId={}, cmd={}.", new Object[]{this.image, this.containerId, JsonTool.toJSONString(createContainerCmd)});
                }
                result.complete(this);
            }
            catch (Exception ex2) {
                result.completeExceptionally(ex2);
            }
        });
        return result;
    }

    private CreateContainerCmd buildCreateCommand() {
        List envList = this.envs.entrySet().stream().filter(e -> e.getValue() != null).map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.toList());
        CreateContainerCmd createContainerCmd = this.goblinDockerClient.createContainerCmd(this.image.getImageName().toIdentifyName()).withEnv(envList).withPrivileged(Boolean.valueOf(this.privilegedMode)).withPublishAllPorts(Boolean.valueOf(true)).withBinds(this.binds);
        if (this.exposedPorts != null) {
            createContainerCmd.withExposedPorts(Stream.of(this.exposedPorts).map(ExposedPort::new).collect(Collectors.toList()));
        }
        if (this.commands.size() > 0) {
            createContainerCmd.withCmd(this.commands);
        }
        return createContainerCmd;
    }

    private String encodeCommandExceptForGroup(CreateContainerCmd createContainerCmd) {
        Map labels = createContainerCmd.getLabels();
        String group = (String)labels.get("group");
        labels.remove("group");
        String cmdJson = JsonTool.toJSONString(createContainerCmd);
        String cmdMd5 = UUID.randomUUID().toString();
        if (StringUtils.isNotBlank(cmdJson)) {
            cmdMd5 = MD5Util.signature(cmdJson);
        }
        labels.put("group", group);
        return cmdMd5;
    }

    private String findContainerByLabel(String label) {
        return StringUtils.isNotBlank(label) ? ((List)this.goblinDockerClient.listContainersCmd().withLabelFilter((Map)ImmutableMap.of((Object)MD5_LABEL, (Object)label)).withLimit(Integer.valueOf(1)).withStatusFilter(Arrays.asList("running")).exec()).stream().findAny().map(it -> it.getId()).orElse("") : "";
    }

    private void containerPreStart() {
    }

    protected void containerStarted() {
    }

    protected void blockUntilContainerStarted() {
    }

    public T addFileSystemBind(String hostPath, String containerPath) {
        if (PlatformUtils.IS_WINDOWS && hostPath.startsWith("/")) {
            this.binds.add(new Bind(hostPath, new Volume(containerPath), AccessMode.DEFAULT, SELContext.DEFAULT));
        } else {
            this.binds.add(new Bind(MountableFile.generateFromHostPath(hostPath).getResolvedPath(), new Volume(containerPath), AccessMode.DEFAULT, SELContext.DEFAULT));
        }
        return (T)((DockerContainerAdapter)this.self());
    }

    @Override
    public T addCopyFileToRuntimeWhenStartup(TransferFile transferFile, String containerPath) {
        Preconditions.checkTrue(transferFile instanceof DockerTransferFile, "transferFile must instanceof DockerTransferFile");
        this.needCopyFiles.put(transferFile, containerPath);
        return (T)((DockerContainerAdapter)this.self());
    }

    private void doCopyFileToContainerWhenStartup() {
        Preconditions.checkNotNull(this.containerId, "copyFileToContainer can only be used with created / running container");
        this.needCopyFiles.forEach((transferFile, containerPath) -> transferFile.transferTo(this.containerId, (String)containerPath));
    }

    @Override
    public boolean shutdown() {
        return false;
    }

    @Override
    public boolean transferFileToRuntime(String filePath, String containerPath) {
        DockerTransferFile.forHostPath(this.goblinDockerClient, filePath).transferTo(this.containerId, containerPath);
        return true;
    }

    @Override
    public RuntimeOperation.ExecResult execInRuntime(Charset outputCharset, String ... commands) {
        return DockerUtils.runCommandInContainer(this.goblinDockerClient, this.containerId, commands);
    }
}

