/*
 * Decompiled with CFR 0.152.
 */
package io.github.oitstack.goblin.runtime.docker.host;

import io.github.oitstack.goblin.runtime.docker.host.DockerHostDiscoverStrategy;
import io.github.oitstack.goblin.runtime.docker.host.DockerHostLocalDiscoverStrategy;
import java.util.ServiceLoader;

public class DockerHostDiscoverFactory {
    private ServiceLoader<DockerHostDiscoverStrategy> discoverStrategies = ServiceLoader.load(DockerHostDiscoverStrategy.class);
    private static final DockerHostDiscoverStrategy DEFAULT_STRATEGY = new DockerHostLocalDiscoverStrategy();

    private DockerHostDiscoverFactory() {
    }

    public static DockerHostDiscoverFactory getInstance() {
        return DockerHostDiscoverFactoryHolder.INSTANCE;
    }

    public DockerHostDiscoverStrategy getDockerHostDiscoverStrategy(String fullClassName) {
        for (DockerHostDiscoverStrategy strategy : this.discoverStrategies) {
            if (!strategy.getClass().getName().equalsIgnoreCase(fullClassName)) continue;
            return strategy;
        }
        return DEFAULT_STRATEGY;
    }

    static class DockerHostDiscoverFactoryHolder {
        public static DockerHostDiscoverFactory INSTANCE = new DockerHostDiscoverFactory();

        DockerHostDiscoverFactoryHolder() {
        }
    }
}

