/*
 * Decompiled with CFR 0.152.
 */
package io.github.oitstack.goblin.runtime.docker.host;

import io.github.oitstack.goblin.runtime.docker.host.DockerHostDiscoverFactory;
import io.github.oitstack.goblin.runtime.docker.host.DockerHostDiscoverStrategy;
import io.github.oitstack.goblin.runtime.docker.utils.StringUtils;
import io.github.oitstack.goblin.runtime.utils.PropertyAndEnvUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.net.telnet.TelnetClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerHostSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerHostSelector.class);
    public static final String DOCKER_HOST_LIST_ENDPOINT = "DOCKER_HOST_LIST_ENDPOINT";
    public static final String DOCKER_HOST_DISCOVER_STRATEGY = "DOCKER_HOST_DISCOVER_STRATEGY";
    private String selectedDockerHost;

    private DockerHostSelector() {
        this.loadDockerHost();
    }

    public static DockerHostSelector getInstance() {
        return DockerHostConfigHolder.INSTANCE;
    }

    private void loadDockerHost() {
        DockerHostDiscoverStrategy dockerHostDiscoverStrategy = DockerHostDiscoverFactory.getInstance().getDockerHostDiscoverStrategy(PropertyAndEnvUtils.get(DOCKER_HOST_DISCOVER_STRATEGY));
        String selectedDockerHost = this.selectOneValidHost(dockerHostDiscoverStrategy.discover());
        if (StringUtils.isBlank(selectedDockerHost)) {
            throw new RuntimeException("no valid docker host.");
        }
        this.selectedDockerHost = selectedDockerHost;
    }

    public String selectOneValidHost(List<String> dockerHostList) {
        if (null == dockerHostList || dockerHostList.size() == 0) {
            LOGGER.error("docker host list is empty");
            return null;
        }
        ArrayList<String> shuffledList = new ArrayList<String>();
        shuffledList.addAll(dockerHostList);
        Collections.shuffle(shuffledList);
        String dockerHost = shuffledList.stream().filter(e -> {
            TelnetClient telnetClient = new TelnetClient();
            String[] hostport = e.split(":");
            boolean succ = false;
            try {
                telnetClient.connect(hostport[0], Integer.parseInt(hostport[1]));
                succ = true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    telnetClient.disconnect();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return succ;
        }).findFirst().get();
        return dockerHost;
    }

    public String getSelectedDockerHost() {
        return this.selectedDockerHost;
    }

    static class DockerHostConfigHolder {
        public static DockerHostSelector INSTANCE = new DockerHostSelector();

        DockerHostConfigHolder() {
        }
    }
}

