/*
 * Decompiled with CFR 0.152.
 */
package io.github.oitstack.goblin.runtime.docker.image.pull;

import io.github.oitstack.goblin.runtime.docker.image.pull.strategies.AlwaysPullStrategy;
import io.github.oitstack.goblin.runtime.docker.image.pull.strategies.CachePullLockStrategy;
import io.github.oitstack.goblin.runtime.docker.image.pull.strategies.CachePullStrategy;
import io.github.oitstack.goblin.runtime.docker.image.pull.strategies.PullStrategy;
import io.github.oitstack.goblin.runtime.docker.image.pull.strategies.TimePullLockStrategy;
import io.github.oitstack.goblin.runtime.docker.image.pull.strategies.TimePullStrategy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PullStrategyFactory {
    public static final String ALWAYS = "ALWAYS";
    public static final String CACHE = "CACHE";
    public static final String AGE = "AGE";
    public static final String CACHE_WITHOUT_LOCK = "CACHE_NO_LOCK";
    public static final String AGE_WITHOUT_LOCK = "AGE_NO_LOCK";
    private static Map<String, PullStrategy> STRATEGY_MAP = new ConcurrentHashMap<String, PullStrategy>();
    private static PullStrategy DEFAULT_PULL_STRATEGY = new AlwaysPullStrategy();

    private PullStrategyFactory() {
    }

    public static PullStrategyFactory getInstance() {
        return PullStrategyFactoryHolder.INSTANCE;
    }

    public PullStrategy getPullStrategy(String strategyName) {
        return STRATEGY_MAP.getOrDefault(strategyName, DEFAULT_PULL_STRATEGY);
    }

    static {
        STRATEGY_MAP.put(ALWAYS, new AlwaysPullStrategy());
        STRATEGY_MAP.put(CACHE, new CachePullLockStrategy());
        STRATEGY_MAP.put(AGE, new TimePullLockStrategy());
        STRATEGY_MAP.put(CACHE_WITHOUT_LOCK, new CachePullStrategy());
        STRATEGY_MAP.put(AGE_WITHOUT_LOCK, new TimePullStrategy());
    }

    static class PullStrategyFactoryHolder {
        public static PullStrategyFactory INSTANCE = new PullStrategyFactory();

        PullStrategyFactoryHolder() {
        }
    }
}

