/*
 * Decompiled with CFR 0.152.
 */
package io.github.oitstack.goblin.runtime.docker.image.pull.fetchers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class FetchContext {
    Boolean upStreamResult = false;
    Long pulledTimeStamp = 0L;
    List<String> exceptions = new ArrayList<String>();

    FetchContext(Boolean upStreamResult, Long pulledTimeStamp, List<String> exceptions) {
        this.upStreamResult = upStreamResult;
        this.pulledTimeStamp = pulledTimeStamp;
        this.exceptions = exceptions;
    }

    public static FetchContextBuilder builder() {
        return new FetchContextBuilder();
    }

    public FetchContextBuilder toBuilder() {
        FetchContextBuilder builder = new FetchContextBuilder().upStreamResult(this.upStreamResult).pulledTimeStamp(this.pulledTimeStamp);
        if (this.exceptions != null) {
            builder.exceptions(this.exceptions);
        }
        return builder;
    }

    public Boolean getUpStreamResult() {
        return this.upStreamResult;
    }

    public Long getPulledTimeStamp() {
        return this.pulledTimeStamp;
    }

    public List<String> getExceptions() {
        return this.exceptions;
    }

    public void setUpStreamResult(Boolean upStreamResult) {
        this.upStreamResult = upStreamResult;
    }

    public void setPulledTimeStamp(Long pulledTimeStamp) {
        this.pulledTimeStamp = pulledTimeStamp;
    }

    public void setExceptions(List<String> exceptions) {
        this.exceptions = exceptions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FetchContext)) {
            return false;
        }
        FetchContext other = (FetchContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$upStreamResult = this.getUpStreamResult();
        Boolean other$upStreamResult = other.getUpStreamResult();
        if (this$upStreamResult == null ? other$upStreamResult != null : !((Object)this$upStreamResult).equals(other$upStreamResult)) {
            return false;
        }
        Long this$pulledTimeStamp = this.getPulledTimeStamp();
        Long other$pulledTimeStamp = other.getPulledTimeStamp();
        if (this$pulledTimeStamp == null ? other$pulledTimeStamp != null : !((Object)this$pulledTimeStamp).equals(other$pulledTimeStamp)) {
            return false;
        }
        List<String> this$exceptions = this.getExceptions();
        List<String> other$exceptions = other.getExceptions();
        return !(this$exceptions == null ? other$exceptions != null : !((Object)this$exceptions).equals(other$exceptions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FetchContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $upStreamResult = this.getUpStreamResult();
        result = result * 59 + ($upStreamResult == null ? 43 : ((Object)$upStreamResult).hashCode());
        Long $pulledTimeStamp = this.getPulledTimeStamp();
        result = result * 59 + ($pulledTimeStamp == null ? 43 : ((Object)$pulledTimeStamp).hashCode());
        List<String> $exceptions = this.getExceptions();
        result = result * 59 + ($exceptions == null ? 43 : ((Object)$exceptions).hashCode());
        return result;
    }

    public String toString() {
        return "FetchContext(upStreamResult=" + this.getUpStreamResult() + ", pulledTimeStamp=" + this.getPulledTimeStamp() + ", exceptions=" + this.getExceptions() + ")";
    }

    public static class FetchContextBuilder {
        private Boolean upStreamResult;
        private Long pulledTimeStamp;
        private ArrayList<String> exceptions;

        FetchContextBuilder() {
        }

        public FetchContextBuilder upStreamResult(Boolean upStreamResult) {
            this.upStreamResult = upStreamResult;
            return this;
        }

        public FetchContextBuilder pulledTimeStamp(Long pulledTimeStamp) {
            this.pulledTimeStamp = pulledTimeStamp;
            return this;
        }

        public FetchContextBuilder exception(String exception) {
            if (this.exceptions == null) {
                this.exceptions = new ArrayList();
            }
            this.exceptions.add(exception);
            return this;
        }

        public FetchContextBuilder exceptions(Collection<? extends String> exceptions) {
            if (exceptions == null) {
                throw new NullPointerException("exceptions cannot be null");
            }
            if (this.exceptions == null) {
                this.exceptions = new ArrayList();
            }
            this.exceptions.addAll(exceptions);
            return this;
        }

        public FetchContextBuilder clearExceptions() {
            if (this.exceptions != null) {
                this.exceptions.clear();
            }
            return this;
        }

        public FetchContext build() {
            List<String> exceptions;
            switch (this.exceptions == null ? 0 : this.exceptions.size()) {
                case 0: {
                    exceptions = Collections.emptyList();
                    break;
                }
                case 1: {
                    exceptions = Collections.singletonList(this.exceptions.get(0));
                    break;
                }
                default: {
                    exceptions = Collections.unmodifiableList(new ArrayList<String>(this.exceptions));
                }
            }
            return new FetchContext(this.upStreamResult, this.pulledTimeStamp, exceptions);
        }

        public String toString() {
            return "FetchContext.FetchContextBuilder(upStreamResult=" + this.upStreamResult + ", pulledTimeStamp=" + this.pulledTimeStamp + ", exceptions=" + this.exceptions + ")";
        }
    }
}

