/*
 * Decompiled with CFR 0.152.
 */
package io.github.oitstack.goblin.runtime.docker.image.pull.fetchers.decorators;

import com.github.dockerjava.api.DockerClient;
import io.github.oitstack.goblin.runtime.docker.image.DockerImageName;
import io.github.oitstack.goblin.runtime.docker.image.cache.ImageCache;
import io.github.oitstack.goblin.runtime.docker.image.pull.fetchers.FetchContext;
import io.github.oitstack.goblin.runtime.docker.image.pull.fetchers.ImageFetcher;

public class RefreshCacheImageFetcherDecorator
implements ImageFetcher {
    private final ImageFetcher imageFetcher;

    public RefreshCacheImageFetcherDecorator(ImageFetcher fetcher) {
        this.imageFetcher = fetcher;
    }

    @Override
    public FetchContext fetch(DockerImageName dockerImageName, DockerClient dockerClient) {
        FetchContext context = this.imageFetcher.fetch(dockerImageName, dockerClient);
        if (context.getUpStreamResult().booleanValue()) {
            ImageCache.ImageData newImageData = ImageCache.getInstance().refresh(dockerImageName, dockerClient);
            return FetchContext.builder().pulledTimeStamp(newImageData.getTime()).upStreamResult(true).build();
        }
        return context.toBuilder().pulledTimeStamp(System.currentTimeMillis()).upStreamResult(false).build();
    }
}

