/*
 * Decompiled with CFR 0.152.
 */
package io.github.oitstack.goblin.runtime.docker.utils;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonTool {
    public static final Logger LOGGER = LoggerFactory.getLogger(JsonTool.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static String toJSONString(Object value) {
        try {
            return objectMapper.writeValueAsString(value);
        }
        catch (Exception e) {
            LOGGER.warn("toJSONString error. value:{}", value, (Object)e);
            return "";
        }
    }

    public static <T> T readValue(String src, Class<T> valueType) {
        try {
            return (T)objectMapper.readValue(src, valueType);
        }
        catch (IOException e) {
            LOGGER.warn("readValue error. value:{}", (Object)src, (Object)e);
            return null;
        }
    }

    static {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.configure(SerializationFeature.FAIL_ON_SELF_REFERENCES, false);
        objectMapper.configure(SerializationFeature.FAIL_ON_UNWRAPPED_TYPE_IDENTIFIERS, false);
        objectMapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
    }
}

