/*
 * Decompiled with CFR 0.152.
 */
package io.github.oitstack.goblin.runtime.transfer;

import io.github.oitstack.goblin.runtime.transfer.FileModeEnums;
import io.github.oitstack.goblin.runtime.transfer.FileUtils;
import io.github.oitstack.goblin.runtime.transfer.Transferable;
import io.github.oitstack.goblin.runtime.transfer.parser.ResourceParserChain;
import io.github.oitstack.goblin.runtime.utils.PathUtils;
import io.github.oitstack.goblin.runtime.utils.PlatformUtils;
import io.github.oitstack.goblin.runtime.utils.TarUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MountableFile
implements Transferable {
    private static final Logger log = LoggerFactory.getLogger(MountableFile.class);
    public static final String SLASH = "/";
    private final String path;
    private final Integer forcedFileMode;
    private final AtomicReference<Object> filesystemPath = new AtomicReference();
    private final AtomicReference<Object> resolvedPath = new AtomicReference();

    private MountableFile(String path, Integer forcedFileMode) {
        this.path = path;
        this.forcedFileMode = forcedFileMode;
    }

    public static MountableFile generateFromHostPath(String path) {
        return MountableFile.generateFromHostPath(path, null);
    }

    public static MountableFile generateFromHostPath(String path, Integer mode) {
        return MountableFile.generateFromHostPath(Paths.get(path, new String[0]), mode);
    }

    public static MountableFile generateFromHostPath(Path path, Integer mode) {
        return new MountableFile(path.toAbsolutePath().toString(), mode);
    }

    private String resolveRuntimePath() {
        String resourcePath = ResourceParserChain.getInstance().start(this.path);
        if (PlatformUtils.IS_WINDOWS && resourcePath.startsWith(SLASH)) {
            resourcePath = resourcePath.substring(1);
        }
        return resourcePath;
    }

    private String resolveLocalFilesystemPath() {
        String resourcePath = ResourceParserChain.getInstance().start(this.path);
        if (PlatformUtils.IS_WINDOWS && resourcePath.startsWith(SLASH)) {
            resourcePath = PathUtils.createMinGWPath(resourcePath).substring(1);
        }
        return resourcePath;
    }

    @Override
    public void transferTo(TarArchiveOutputStream outputStream, String destinationPathInTar) {
        TarUtils.recursiveCopyTar(destinationPathInTar, this.getResolvedPath(), this.getResolvedPath(), outputStream);
    }

    @Override
    public byte[] getBytes() {
        return new byte[0];
    }

    @Override
    public long getSize() {
        File file = new File(this.getResolvedPath());
        if (file.isFile()) {
            return file.length();
        }
        return 0L;
    }

    @Override
    public String getDescription() {
        return this.getResolvedPath();
    }

    @Override
    public int getFileMode() {
        return this.getUnixFileMode(this.getResolvedPath());
    }

    private int getUnixFileMode(String pathAsString) {
        Path path = Paths.get(pathAsString, new String[0]);
        if (this.forcedFileMode != null) {
            return this.getModeValue(path);
        }
        return FileUtils.getUnixFileMode(path);
    }

    private int getModeValue(Path path) {
        int result = Files.isDirectory(path, new LinkOption[0]) ? FileModeEnums.DIR_000.getMode() : FileModeEnums.FILE_000.getMode();
        return result | this.forcedFileMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFilesystemPath() {
        Object value = this.filesystemPath.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.filesystemPath;
            synchronized (atomicReference) {
                value = this.filesystemPath.get();
                if (value == null) {
                    String actualValue = this.resolveLocalFilesystemPath();
                    value = actualValue == null ? this.filesystemPath : actualValue;
                    this.filesystemPath.set(value);
                }
            }
        }
        return (String)(value == this.filesystemPath ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResolvedPath() {
        Object value = this.resolvedPath.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.resolvedPath;
            synchronized (atomicReference) {
                value = this.resolvedPath.get();
                if (value == null) {
                    String actualValue = this.resolveRuntimePath();
                    value = actualValue == null ? this.resolvedPath : actualValue;
                    this.resolvedPath.set(value);
                }
            }
        }
        return (String)(value == this.resolvedPath ? null : value);
    }
}

