/*
 * Decompiled with CFR 0.152.
 */
package io.github.oitstack.goblin.runtime.utils;

import io.github.oitstack.goblin.runtime.transfer.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarUtils {
    private static Logger log = LoggerFactory.getLogger(TarUtils.class);

    public static void recursiveCopyTar(String entryFilename, String rootPath, String itemPath, TarArchiveOutputStream tarArchive) {
        try {
            ResolvedFile resoveledFile = ResolvedFile.of(itemPath, rootPath);
            TarUtils.copyFileToArchive(tarArchive, resoveledFile, entryFilename);
            File[] children = resoveledFile.getSourceFile().listFiles();
            if (children != null) {
                for (File child : children) {
                    TarUtils.recursiveCopyTar(entryFilename, resoveledFile.getSourceRootPath().getCanonicalPath(), child.getCanonicalPath(), tarArchive);
                }
            }
        }
        catch (IOException e) {
            log.error("Error when copying TAR file entry: {}", (Object)itemPath, (Object)e);
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFileToArchive(TarArchiveOutputStream tarArchive, ResolvedFile resoveledFile, String entryFilename) throws IOException {
        try {
            TarArchiveEntry tarEntry = TarUtils.assemblyTarEntry(resoveledFile, entryFilename);
            tarArchive.putArchiveEntry((ArchiveEntry)tarEntry);
            if (resoveledFile.getSourceFile().isFile()) {
                Files.copy(resoveledFile.getSourceFile().toPath(), (OutputStream)tarArchive);
            }
        }
        finally {
            tarArchive.closeArchiveEntry();
        }
    }

    private static TarArchiveEntry assemblyTarEntry(ResolvedFile resoveledFile, String entryFilename) throws IOException {
        String tarEntryFilename = TarUtils.formatEntryFileName(entryFilename, resoveledFile);
        TarArchiveEntry tarEntry = new TarArchiveEntry(resoveledFile.getSourceFile(), tarEntryFilename);
        tarEntry.setMode(FileUtils.getUnixFileMode(Paths.get(resoveledFile.getSourceFile().getCanonicalPath(), new String[0])));
        return tarEntry;
    }

    private static String formatEntryFileName(String entryFilename, ResolvedFile resoveledFile) {
        String tarEntryFilename = resoveledFile.getRelativePathToSourceFile().isEmpty() ? entryFilename : entryFilename + "/" + resoveledFile.getRelativePathToSourceFile();
        return tarEntryFilename.replaceAll("^/", "");
    }

    static class ResolvedFile {
        final File sourceFile;
        final File sourceRootPath;
        final String relativePathToSourceFile;

        private ResolvedFile(String filePath, String rootPath) throws IOException {
            File sourceFile = new File(filePath).getCanonicalFile();
            File sourceRootPath = new File(rootPath).getCanonicalFile();
            String relativePathToSourceFile = sourceRootPath.toPath().relativize(sourceFile.toPath()).toFile().toString();
            this.sourceFile = sourceFile;
            this.sourceRootPath = sourceRootPath;
            this.relativePathToSourceFile = relativePathToSourceFile;
        }

        public static ResolvedFile of(String filePath, String rootPath) throws IOException {
            return new ResolvedFile(filePath, rootPath);
        }

        public File getSourceFile() {
            return this.sourceFile;
        }

        public File getSourceRootPath() {
            return this.sourceRootPath;
        }

        public String getRelativePathToSourceFile() {
            return this.relativePathToSourceFile;
        }
    }
}

