/*
 * Decompiled with CFR 0.152.
 */
package io.github.oitstack.goblin.runtime.docker.client;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Volume;
import io.github.oitstack.goblin.runtime.config.RunTimeConfig;
import io.github.oitstack.goblin.runtime.docker.image.DockerImageName;
import io.github.oitstack.goblin.runtime.docker.image.cache.ImageCache;
import io.github.oitstack.goblin.runtime.docker.utils.DockerUtils;
import io.github.oitstack.goblin.runtime.docker.utils.StringUtils;
import io.github.oitstack.goblin.runtime.utils.MixAll;
import io.github.oitstack.goblin.runtime.utils.PlatformUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DamoclesManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DamoclesManager.class);
    private DockerClient client;
    private ImageCache imageCache = ImageCache.getInstance();
    private static final int EXPOSED_PORT = 8080;
    private static final String DEFAULT_DAMOCLES_TAG = "oitstack/damocles:v0.0.3";
    private AtomicBoolean damoclesStarted = new AtomicBoolean(false);

    public DamoclesManager(DockerClient client) {
        this.client = client;
    }

    public void startAndRegisterClient(String clientIdentify, URI dockerHost) {
        if (this.damoclesStarted.compareAndSet(false, true)) {
            String damoclesTag = RunTimeConfig.getInstance().getDamoclesTag();
            DockerImageName imageName = DockerImageName.parseFrom(StringUtils.isBlank(damoclesTag) ? DEFAULT_DAMOCLES_TAG : damoclesTag);
            try {
                this.pullDamoclesImage(this.client, imageName);
                String containerId = MixAll.retry(3, () -> this.startUpDamocles(clientIdentify, dockerHost, imageName));
                if (null != containerId) {
                    DamoclesManager.connectToDamocles(this.client, dockerHost, containerId);
                } else {
                    LOGGER.error("Damocles StartUp Failed.");
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("Damocles StartUp Failed", (Throwable)e);
            }
        }
    }

    private synchronized void pullDamoclesImage(DockerClient client, DockerImageName imageName) throws InterruptedException {
        ImageCache.ImageData imageData = this.imageCache.get(imageName);
        if (null != imageData) {
            return;
        }
        if (!DockerUtils.imageExist(client, imageName)) {
            client.pullImageCmd(imageName.toIdentifyName()).withTag(imageName.getVersion().getVersionDesc()).start().awaitCompletion();
        }
        this.imageCache.refresh(imageName, client);
    }

    private static void connectToDamocles(DockerClient client, URI dockerHost, String containerId) {
        InspectContainerResponse inspectContainerResponse = client.inspectContainerCmd(containerId).exec();
        Integer port = DockerUtils.getFirstMappedPort(inspectContainerResponse, Arrays.asList(new ExposedPort(8080)));
        String host = DockerUtils.getDockerHostIpAddress(client, dockerHost);
        Thread connThread = new Thread(() -> {
            Socket clientSocket = new Socket();
            try {
                clientSocket.connect(new InetSocketAddress(host, (int)port), 5000);
                OutputStream output = clientSocket.getOutputStream();
                Executors.newSingleThreadScheduledExecutor().scheduleWithFixedDelay(() -> {
                    try {
                        PrintWriter writer = new PrintWriter(output, true);
                        writer.println("PING");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }, 3L, 1L, TimeUnit.SECONDS);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        connThread.setDaemon(true);
        connThread.setName("damocles client");
        connThread.start();
    }

    private String startUpDamocles(String clientIdentify, URI dockerHost, DockerImageName imageName) {
        CreateContainerCmd createContainerCmd = this.client.createContainerCmd(imageName.toIdentifyName());
        ArrayList<Bind> binds = new ArrayList<Bind>();
        binds.add(new Bind(this.getRemoteDockerUnixSocketPath(dockerHost), new Volume("/var/run/docker.sock")));
        String containerId = createContainerCmd.withBinds(binds).withExposedPorts(new ExposedPort[]{new ExposedPort(8080)}).withName("goblin-damocles-" + clientIdentify).withPublishAllPorts(Boolean.valueOf(true)).withPrivileged(Boolean.valueOf(true)).withEnv(new String[]{"targetName=group=" + clientIdentify}).exec().getId();
        this.client.startContainerCmd(containerId).exec();
        return containerId;
    }

    public String getRemoteDockerUnixSocketPath(URI dockerHost) {
        String dockerSocketOverride = RunTimeConfig.getInstance().get("GOBLIN_RUNTIME__docker_socket_override");
        if (!StringUtils.isBlank(dockerSocketOverride)) {
            return dockerSocketOverride;
        }
        String path = "unix".equals(dockerHost.getScheme()) ? dockerHost.getRawPath() : "/var/run/docker.sock";
        return PlatformUtils.IS_WINDOWS ? "/" + path : path;
    }

    public ImageCache getImageCache() {
        return this.imageCache;
    }

    public void setImageCache(ImageCache imageCache) {
        this.imageCache = imageCache;
    }
}

