/*
 * Decompiled with CFR 0.152.
 */
package io.github.oitstack.goblin.runtime.docker.host;

import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.classic.methods.HttpGet;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.config.RequestConfig;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.ClassicHttpRequest;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.HttpEntity;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.ParseException;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.io.entity.EntityUtils;
import io.github.oitstack.goblin.runtime.docker.host.DockerHostDiscoverStrategy;
import io.github.oitstack.goblin.runtime.docker.utils.StringUtils;
import io.github.oitstack.goblin.runtime.utils.PropertyAndEnvUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerHostHttpDiscoverStrategy
implements DockerHostDiscoverStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerHostHttpDiscoverStrategy.class);

    @Override
    public List<String> discover() {
        String url = PropertyAndEnvUtils.get("DOCKER_HOST_LIST_ENDPOINT");
        if (StringUtils.isBlank(url)) {
            LOGGER.error("DOCKER_HOST_LIST_ENDPOINT is not configured.");
            throw new RuntimeException("DOCKER_HOST_LIST_ENDPOINT is not configured.");
        }
        RequestConfig config = RequestConfig.custom().setConnectTimeout(100L, TimeUnit.MILLISECONDS).setConnectionRequestTimeout(100L, TimeUnit.MILLISECONDS).setResponseTimeout(100L, TimeUnit.MILLISECONDS).build();
        ArrayList<String> dockerHostList = new ArrayList<String>();
        try (CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(config).build();){
            HttpGet getMethod = new HttpGet(url);
            try (CloseableHttpResponse response = client.execute((ClassicHttpRequest)getMethod);){
                String content = EntityUtils.toString((HttpEntity)response.getEntity());
                LOGGER.info("get dockerhost list from remote server. response was: {}, {}", (Object)response.getCode(), (Object)content);
                if (response.getCode() != 200) {
                    throw new RuntimeException(String.format("get dockerhost list from remote server failed. code:", response.getCode()));
                }
                Arrays.asList(content.split(",")).stream().forEach(hostpost -> dockerHostList.add((String)hostpost));
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
        catch (ParseException | IOException e) {
            e.printStackTrace();
        }
        return dockerHostList;
    }
}

